/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.mail;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.extra.mail.GlobalMailAccount;
import org.aoju.bus.extra.mail.Mail;
import org.aoju.bus.extra.mail.MailAccount;

public class MailUtils {
    public static void sendText(String to, String subject, String content, File ... files) {
        MailUtils.send(to, subject, content, false, files);
    }

    public static void sendHtml(String to, String subject, String content, File ... files) {
        MailUtils.send(to, subject, content, true, files);
    }

    public static void send(String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtils.send(MailUtils.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(String to, String cc, String bcc, String subject, String content, boolean isHtml, File ... files) {
        MailUtils.send(MailUtils.splitAddress(to), MailUtils.splitAddress(cc), MailUtils.splitAddress(bcc), subject, content, isHtml, files);
    }

    public static void sendText(Collection<String> tos, String subject, String content, File ... files) {
        MailUtils.send(tos, subject, content, false, files);
    }

    public static void sendHtml(Collection<String> tos, String subject, String content, File ... files) {
        MailUtils.send(tos, subject, content, true, files);
    }

    public static void send(Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        MailUtils.send(GlobalMailAccount.INSTANCE.getAccount(), tos, subject, content, isHtml, files);
    }

    public static void send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        MailUtils.send(GlobalMailAccount.INSTANCE.getAccount(), tos, ccs, bccs, subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtils.send(mailAccount, MailUtils.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        Mail.create(mailAccount).setTos(tos.toArray(new String[tos.size()])).setTitle(subject).setContent(content).setHtml(isHtml).setFiles(files).send();
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        Mail mail = Mail.create(mailAccount);
        if (CollUtils.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[ccs.size()]));
        }
        if (CollUtils.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[bccs.size()]));
        }
        mail.setTos(tos.toArray(new String[tos.size()]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (StringUtils.isBlank(addresses)) {
            return null;
        }
        List<String> result = StringUtils.contains((CharSequence)addresses, ',') ? StringUtils.splitTrim((CharSequence)addresses, ',') : (StringUtils.contains((CharSequence)addresses, ';') ? StringUtils.splitTrim((CharSequence)addresses, ';') : CollUtils.newArrayList(addresses));
        return result;
    }
}

