/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.common.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.PdhUtil;
import com.sun.jna.platform.win32.Win32Exception;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.common.windows.PerfCounterQuery;
import org.aoju.bus.health.common.windows.PerfDataUtils;
import org.aoju.bus.health.common.windows.WmiUtils;
import org.aoju.bus.logger.Logger;

public class PerfWildcardQuery<T extends Enum<T>>
extends PerfCounterQuery<T> {
    private final String perfObjectLocalized;
    private final String instanceFilter;
    private EnumMap<T, List<PerfDataUtils.PerfCounter>> counterListMap = null;
    private List<String> instancesFromLastQuery = new ArrayList<String>();

    public PerfWildcardQuery(Class<T> propertyEnum, String perfObject, String perfWmiClass) {
        this(propertyEnum, perfObject, perfWmiClass, perfObject);
    }

    public PerfWildcardQuery(Class<T> propertyEnum, String perfObject, String perfWmiClass, String queryKey) {
        super(propertyEnum, perfObject, perfWmiClass, queryKey);
        if (((Enum[])propertyEnum.getEnumConstants()).length < 2) {
            throw new IllegalArgumentException("Enum " + propertyEnum.getName() + " must have at least two elements, an instance filter and a counter.");
        }
        this.instanceFilter = ((PdhCounterWildcardProperty)((Object)((Enum[])propertyEnum.getEnumConstants())[0])).getCounter().toLowerCase();
        this.perfObjectLocalized = PerfWildcardQuery.localize(this.perfObject);
    }

    private static String localize(String perfObject) {
        String localized = null;
        try {
            localized = PdhUtil.PdhLookupPerfNameByIndex(null, (int)PdhUtil.PdhLookupPerfIndexByEnglishName((String)perfObject));
        }
        catch (Win32Exception e) {
            Logger.error("Unable to locate English counter names in registry Perflib 009. Assuming English counters.", new Object[0]);
        }
        if (localized == null || localized.length() == 0) {
            return perfObject;
        }
        Logger.debug("Localized {} to {}", perfObject, localized);
        return localized;
    }

    @Override
    protected boolean initPdhCounters() {
        return this.fillCounterListMap();
    }

    @Override
    protected void unInitPdhCounters() {
        this.pdhQueryHandler.removeAllCountersFromQuery(this.queryKey);
        this.counterListMap = null;
    }

    @Override
    public Map<T, Long> queryValues() {
        throw new UnsupportedOperationException("Use queryValuesWildcard() on this class.");
    }

    public Map<T, List<Long>> queryValuesWildcard() {
        EnumMap valueMap = new EnumMap(this.propertyEnum);
        this.instancesFromLastQuery.clear();
        Enum[] props = (Enum[])this.propertyEnum.getEnumConstants();
        if (this.source.equals((Object)PerfCounterQuery.CounterDataSource.PDH)) {
            if (this.initPdhCounters() && this.queryPdhWildcard(valueMap, props)) {
                this.unInitPdhCounters();
            } else {
                this.setDataSource(PerfCounterQuery.CounterDataSource.WMI);
            }
        }
        if (this.source.equals((Object)PerfCounterQuery.CounterDataSource.WMI)) {
            this.queryWmiWildcard(valueMap, props);
        }
        return valueMap;
    }

    private boolean queryPdhWildcard(Map<T, List<Long>> valueMap, T[] props) {
        if (this.counterListMap != null && 0L < this.pdhQueryHandler.updateQuery(this.queryKey)) {
            for (int i = 1; i < props.length; ++i) {
                T prop = props[i];
                ArrayList<Long> values = new ArrayList<Long>();
                for (PerfDataUtils.PerfCounter counter : this.counterListMap.get(prop)) {
                    values.add(this.pdhQueryHandler.queryCounter(counter));
                    if (i != 1) continue;
                    this.instancesFromLastQuery.add(counter.getInstance());
                }
                valueMap.put(prop, values);
            }
            return true;
        }
        return false;
    }

    private void queryWmiWildcard(Map<T, List<Long>> valueMap, T[] props) {
        WbemcliUtil.WmiResult result = this.wmiQueryHandler.queryWMI(this.counterQuery);
        if (result.getResultCount() > 0) {
            for (int i = 0; i < result.getResultCount(); ++i) {
                this.instancesFromLastQuery.add(WmiUtils.getString(result, props[0], i));
            }
            for (int p = 1; p < props.length; ++p) {
                T prop = props[p];
                ArrayList<Long> values = new ArrayList<Long>();
                block8: for (int i = 0; i < result.getResultCount(); ++i) {
                    switch (result.getCIMType(prop)) {
                        case 18: {
                            values.add(Long.valueOf(WmiUtils.getUint16(result, prop, i)));
                            continue block8;
                        }
                        case 19: {
                            values.add(WmiUtils.getUint32asLong(result, prop, i));
                            continue block8;
                        }
                        case 21: {
                            values.add(WmiUtils.getUint64(result, prop, i));
                            continue block8;
                        }
                        case 101: {
                            values.add(WmiUtils.getDateTime(result, prop, i).toInstant().toEpochMilli());
                            continue block8;
                        }
                        default: {
                            throw new ClassCastException("Unimplemented CIM Type Mapping.");
                        }
                    }
                }
                valueMap.put(prop, values);
            }
        }
    }

    public List<String> getInstancesFromLastQuery() {
        return this.instancesFromLastQuery;
    }

    private boolean fillCounterListMap() {
        PdhUtil.PdhEnumObjectItems objectItems;
        try {
            objectItems = PdhUtil.PdhEnumObjectItems(null, null, (String)this.perfObjectLocalized, (int)100);
        }
        catch (PdhUtil.PdhException e) {
            return false;
        }
        List instances = objectItems.getInstances();
        instances.removeIf(i -> !Builder.wildcardMatch(i.toLowerCase(), this.instanceFilter));
        HashSet instancesToAdd = new HashSet(instances);
        this.counterListMap = new EnumMap(this.propertyEnum);
        for (int i2 = 1; i2 < ((Enum[])this.propertyEnum.getEnumConstants()).length; ++i2) {
            Enum prop = ((Enum[])this.propertyEnum.getEnumConstants())[i2];
            ArrayList<PerfDataUtils.PerfCounter> counterList = new ArrayList<PerfDataUtils.PerfCounter>(instances.size());
            for (String instance : instancesToAdd) {
                PerfDataUtils.PerfCounter counter = PerfDataUtils.createCounter(this.perfObject, instance, ((PdhCounterWildcardProperty)((Object)prop)).getCounter());
                if (!this.pdhQueryHandler.addCounterToQuery(counter, this.queryKey)) {
                    this.unInitPdhCounters();
                    return false;
                }
                counterList.add(counter);
            }
            this.counterListMap.put(prop, counterList);
        }
        return this.counterListMap.size() > 0;
    }

    public static interface PdhCounterWildcardProperty {
        public String getCounter();
    }
}

