/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.solaris;

import java.util.ArrayList;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.hardware.AbstractSensors;

public class SolarisSensors
extends AbstractSensors {
    @Override
    public double queryCpuTemperature() {
        double maxTemp = 0.0;
        for (String line : Command.runNative("/usr/sbin/prtpicl -v -c temperature-sensor")) {
            int temp;
            if (!line.trim().startsWith("Temperature:") || !((double)(temp = Builder.parseLastInt(line, 0)) > maxTemp)) continue;
            maxTemp = temp;
        }
        if (maxTemp > 1000.0) {
            maxTemp /= 1000.0;
        }
        return maxTemp;
    }

    @Override
    public int[] queryFanSpeeds() {
        ArrayList<Integer> speedList = new ArrayList<Integer>();
        for (String line : Command.runNative("/usr/sbin/prtpicl -v -c fan")) {
            if (!line.trim().startsWith("Speed:")) continue;
            speedList.add(Builder.parseLastInt(line, 0));
        }
        int[] fans = new int[speedList.size()];
        for (int i = 0; i < speedList.size(); ++i) {
            fans[i] = (Integer)speedList.get(i);
        }
        return fans;
    }

    @Override
    public double queryCpuVoltage() {
        double voltage = 0.0;
        for (String line : Command.runNative("/usr/sbin/prtpicl -v -c voltage-sensor")) {
            if (!line.trim().startsWith("Voltage:")) continue;
            voltage = Builder.parseDoubleOrDefault(line.replace("Voltage:", "").trim(), 0.0);
            break;
        }
        return voltage;
    }
}

