/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.cache;

import java.io.IOException;
import java.io.OutputStream;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.io.Sink;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.cache.CacheRequest;
import org.aoju.bus.http.cache.CacheStrategy;
import org.aoju.bus.http.cache.InternalCache;
import org.aoju.bus.http.cache.NetApiConvert;

public final class CacheAdapter
implements InternalCache {
    private final ResponseCache delegate;

    public CacheAdapter(ResponseCache delegate) {
        this.delegate = delegate;
    }

    public ResponseCache getDelegate() {
        return this.delegate;
    }

    @Override
    public Response get(Request request) throws IOException {
        CacheResponse javaResponse = this.getJavaCachedResponse(request);
        if (javaResponse == null) {
            return null;
        }
        return NetApiConvert.createResponseForCacheGet(request, javaResponse);
    }

    @Override
    public CacheRequest put(Response response) throws IOException {
        HttpURLConnection connection;
        URI uri = response.request().url().uri();
        final java.net.CacheRequest request = this.delegate.put(uri, connection = NetApiConvert.createJavaUrlConnectionForCachePut(response));
        if (request == null) {
            return null;
        }
        return new CacheRequest(){

            @Override
            public Sink body() throws IOException {
                OutputStream body = request.getBody();
                return body != null ? IoUtils.sink(body) : null;
            }

            @Override
            public void abort() {
                request.abort();
            }
        };
    }

    @Override
    public void remove(Request request) {
    }

    @Override
    public void update(Response cached, Response network) {
    }

    @Override
    public void trackConditionalCacheHit() {
    }

    @Override
    public void trackResponse(CacheStrategy cacheStrategy) {
    }

    private CacheResponse getJavaCachedResponse(Request request) throws IOException {
        Map<String, List<String>> headers = NetApiConvert.extractJavaHeaders(request);
        return this.delegate.get(request.url().uri(), request.method(), headers);
    }
}

