/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.freebsd;

import java.util.function.Supplier;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.unix.freebsd.BsdSysctlUtils;
import org.aoju.bus.health.hardware.AbstractVirtualMemory;

public class FreeBsdVirtualMemory
extends AbstractVirtualMemory {
    private final Supplier<Long> used = Memoizer.memoize(this::querySwapUsed, Memoizer.defaultExpiration());
    private final Supplier<Long> total = Memoizer.memoize(this::querySwapTotal, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesIn = Memoizer.memoize(this::queryPagesIn, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesOut = Memoizer.memoize(this::queryPagesOut, Memoizer.defaultExpiration());

    @Override
    public long getSwapUsed() {
        return this.used.get();
    }

    @Override
    public long getSwapTotal() {
        return this.total.get();
    }

    @Override
    public long getSwapPagesIn() {
        return this.pagesIn.get();
    }

    @Override
    public long getSwapPagesOut() {
        return this.pagesOut.get();
    }

    private long querySwapUsed() {
        String swapInfo = Command.getAnswerAt("swapinfo -k", 1);
        String[] split = Builder.whitespaces.split(swapInfo);
        if (split.length < 5) {
            return 0L;
        }
        return Builder.parseLongOrDefault(split[2], 0L) << 10;
    }

    private long querySwapTotal() {
        return BsdSysctlUtils.sysctl("vm.swap_total", 0L);
    }

    private long queryPagesIn() {
        return BsdSysctlUtils.sysctl("vm.stats.vm.v_swappgsin", 0L);
    }

    private long queryPagesOut() {
        return BsdSysctlUtils.sysctl("vm.stats.vm.v_swappgsout", 0L);
    }
}

