/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.function.Supplier;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.windows.WmiQueryHandler;
import org.aoju.bus.health.common.windows.WmiUtils;
import org.aoju.bus.health.hardware.AbstractBaseboard;

final class WindowsBaseboard
extends AbstractBaseboard {
    private final Supplier<WmiStrings> wmi = Memoizer.memoize(this::queryWmi);

    WindowsBaseboard() {
    }

    @Override
    public String getManufacturer() {
        return this.wmi.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.wmi.get().model;
    }

    @Override
    public String getVersion() {
        return this.wmi.get().version;
    }

    @Override
    public String getSerialNumber() {
        return this.wmi.get().serialNumber;
    }

    private WmiStrings queryWmi() {
        WbemcliUtil.WmiQuery baseboardQuery = new WbemcliUtil.WmiQuery("Win32_BaseBoard", BaseboardProperty.class);
        WbemcliUtil.WmiResult win32BaseBoard = WmiQueryHandler.createInstance().queryWMI(baseboardQuery);
        if (win32BaseBoard.getResultCount() > 0) {
            return new WmiStrings(WmiUtils.getString(win32BaseBoard, BaseboardProperty.MANUFACTURER, 0), WmiUtils.getString(win32BaseBoard, BaseboardProperty.MODEL, 0), WmiUtils.getString(win32BaseBoard, BaseboardProperty.VERSION, 0), WmiUtils.getString(win32BaseBoard, BaseboardProperty.SERIALNUMBER, 0));
        }
        return new WmiStrings("unknown", "unknown", "unknown", "unknown");
    }

    private static final class WmiStrings {
        private final String manufacturer;
        private final String model;
        private final String version;
        private final String serialNumber;

        private WmiStrings(String manufacturer, String model, String version, String serialNumber) {
            this.manufacturer = StringUtils.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = StringUtils.isBlank(model) ? "unknown" : model;
            this.version = StringUtils.isBlank(version) ? "unknown" : version;
            this.serialNumber = StringUtils.isBlank(serialNumber) ? "unknown" : serialNumber;
        }
    }

    static enum BaseboardProperty {
        MANUFACTURER,
        MODEL,
        VERSION,
        SERIALNUMBER;

    }
}

