/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.log4j;

import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.AbstractAware;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLog
extends AbstractAware {
    private final Logger logger;

    public Log4jLog(Logger logger) {
        this.logger = logger;
    }

    public Log4jLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public Log4jLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTrace() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, org.aoju.bus.logger.level.Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebug() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, org.aoju.bus.logger.level.Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfo() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, org.aoju.bus.logger.level.Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarn() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, org.aoju.bus.logger.level.Level.WARN, t, format, arguments);
    }

    @Override
    public boolean isError() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, org.aoju.bus.logger.level.Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(String fqcn, org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        Level log4jLevel;
        switch (level) {
            case TRACE: {
                log4jLevel = Level.TRACE;
                break;
            }
            case DEBUG: {
                log4jLevel = Level.DEBUG;
                break;
            }
            case INFO: {
                log4jLevel = Level.INFO;
                break;
            }
            case WARN: {
                log4jLevel = Level.WARN;
                break;
            }
            case ERROR: {
                log4jLevel = Level.ERROR;
                break;
            }
            default: {
                throw new Error(StringUtils.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        if (this.logger.isEnabledFor((Priority)log4jLevel)) {
            this.logger.log(fqcn, (Priority)log4jLevel, (Object)StringUtils.format(format, arguments), t);
        }
    }
}

