/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.slf4j;

import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.AbstractAware;
import org.aoju.bus.logger.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLog
extends AbstractAware {
    private final transient Logger logger;
    private final boolean isLocationAwareLogger;

    public Slf4jLog(Logger logger) {
        this.logger = logger;
        this.isLocationAwareLogger = logger instanceof LocationAwareLogger;
    }

    public Slf4jLog(Class<?> clazz) {
        this(Slf4jLog.getSlf4jLogger(clazz));
    }

    public Slf4jLog(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    private static Logger getSlf4jLogger(Class<?> clazz) {
        return null == clazz ? LoggerFactory.getLogger((String)"") : LoggerFactory.getLogger(clazz);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTrace() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isTrace()) {
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 0, t, format, arguments);
            } else {
                this.logger.trace(StringUtils.format(format, arguments), t);
            }
        }
    }

    @Override
    public boolean isDebug() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isDebug()) {
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 10, t, format, arguments);
            } else {
                this.logger.debug(StringUtils.format(format, arguments), t);
            }
        }
    }

    @Override
    public boolean isInfo() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isInfo()) {
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 20, t, format, arguments);
            } else {
                this.logger.info(StringUtils.format(format, arguments), t);
            }
        }
    }

    @Override
    public boolean isWarn() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isWarn()) {
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 30, t, format, arguments);
            } else {
                this.logger.warn(StringUtils.format(format, arguments), t);
            }
        }
    }

    @Override
    public boolean isError() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isError()) {
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 40, t, format, arguments);
            } else {
                this.logger.error(StringUtils.format(format, arguments), t);
            }
        }
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(fqcn, t, format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(fqcn, t, format, arguments);
                break;
            }
            case INFO: {
                this.info(fqcn, t, format, arguments);
                break;
            }
            case WARN: {
                this.warn(fqcn, t, format, arguments);
                break;
            }
            case ERROR: {
                this.error(fqcn, t, format, arguments);
                break;
            }
            default: {
                throw new Error(StringUtils.format("Can not identify level: {}", new Object[]{level}));
            }
        }
    }

    private void locationAwareLog(LocationAwareLogger logger, String fqcn, int level_int, Throwable t, String msgTemplate, Object[] arguments) {
        logger.log(null, fqcn, level_int, StringUtils.format(msgTemplate, arguments), null, t);
    }
}

