/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.builder;

import java.util.Set;
import org.aoju.bus.mapper.annotation.Version;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.entity.EntityTableName;
import org.aoju.bus.mapper.version.VersionException;

public class SqlSourceBuilder {
    public static String getDynamicTableName(Class<?> entityClass, String tableName) {
        if (EntityTableName.class.isAssignableFrom(entityClass)) {
            StringBuilder sql = new StringBuilder();
            sql.append("<choose>");
            sql.append("<when test=\"@org.aoju.bus.mapper.builder.OGNL@isDynamicParameter(_parameter) and dynamicTableName != null and dynamicTableName != ''\">");
            sql.append("${dynamicTableName}\n");
            sql.append("</when>");
            sql.append("<otherwise>");
            sql.append(tableName);
            sql.append("</otherwise>");
            sql.append("</choose>");
            return sql.toString();
        }
        return tableName;
    }

    public static String getDynamicTableName(Class<?> entityClass, String tableName, String parameterName) {
        if (EntityTableName.class.isAssignableFrom(entityClass)) {
            if (Assert.isNotEmpty(parameterName)) {
                StringBuilder sql = new StringBuilder();
                sql.append("<choose>");
                sql.append("<when test=\"@org.aoju.bus.mapper.builder.OGNL@isDynamicParameter(" + parameterName + ") and " + parameterName + ".dynamicTableName != null and " + parameterName + ".dynamicTableName != ''\">");
                sql.append("${" + parameterName + ".dynamicTableName}");
                sql.append("</when>");
                sql.append("<otherwise>");
                sql.append(tableName);
                sql.append("</otherwise>");
                sql.append("</choose>");
                return sql.toString();
            }
            return SqlSourceBuilder.getDynamicTableName(entityClass, tableName);
        }
        return tableName;
    }

    public static String getBindCache(EntityColumn column) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"");
        sql.append(column.getProperty()).append("_cache\" ");
        sql.append("value=\"").append(column.getProperty()).append("\"/>");
        return sql.toString();
    }

    public static String getBindValue(EntityColumn column, String value) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"");
        sql.append(column.getProperty()).append("_bind\" ");
        sql.append("value='").append(value).append("'/>");
        return sql.toString();
    }

    public static String getIfCacheNotNull(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"").append(column.getProperty()).append("_cache != null\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfCacheIsNull(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"").append(column.getProperty()).append("_cache == null\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfNotNull(EntityColumn column, String contents, boolean empty) {
        return SqlSourceBuilder.getIfNotNull(null, column, contents, empty);
    }

    public static String getIfIsNull(EntityColumn column, String contents, boolean empty) {
        return SqlSourceBuilder.getIfIsNull(null, column, contents, empty);
    }

    public static String getIfNotNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        if (Assert.isNotEmpty(entityName)) {
            sql.append(entityName).append(".");
        }
        sql.append(column.getProperty()).append(" != null");
        if (empty && column.getJavaType().equals(String.class)) {
            sql.append(" and ");
            if (Assert.isNotEmpty(entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty()).append(" != '' ");
        }
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfIsNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        if (Assert.isNotEmpty(entityName)) {
            sql.append(entityName).append(".");
        }
        sql.append(column.getProperty()).append(" == null");
        if (empty && column.getJavaType().equals(String.class)) {
            sql.append(" or ");
            if (Assert.isNotEmpty(entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty()).append(" == '' ");
        }
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getAllColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        StringBuilder sql = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            sql.append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }

    public static String selectAllColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SqlSourceBuilder.getAllColumns(entityClass));
        sql.append(" ");
        return sql.toString();
    }

    public static String selectCount(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        Set<EntityColumn> pkColumns = EntityBuilder.getPKColumns(entityClass);
        if (pkColumns.size() == 1) {
            sql.append("COUNT(").append(pkColumns.iterator().next().getColumn()).append(") ");
        } else {
            sql.append("COUNT(*) ");
        }
        return sql.toString();
    }

    public static String selectCountExists(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT CASE WHEN ");
        Set<EntityColumn> pkColumns = EntityBuilder.getPKColumns(entityClass);
        if (pkColumns.size() == 1) {
            sql.append("COUNT(").append(pkColumns.iterator().next().getColumn()).append(") ");
        } else {
            sql.append("COUNT(*) ");
        }
        sql.append(" > 0 THEN 1 ELSE 0 END AS result ");
        return sql.toString();
    }

    public static String fromTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" FROM ");
        sql.append(SqlSourceBuilder.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String updateTable(Class<?> entityClass, String defaultTableName) {
        return SqlSourceBuilder.updateTable(entityClass, defaultTableName, null);
    }

    public static String updateTable(Class<?> entityClass, String defaultTableName, String entityName) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(SqlSourceBuilder.getDynamicTableName(entityClass, defaultTableName, entityName));
        sql.append(" ");
        return sql.toString();
    }

    public static String deleteFromTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(SqlSourceBuilder.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String insertIntoTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(SqlSourceBuilder.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String insertColumns(Class<?> entityClass, boolean skipId, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (!column.isInsertable() || skipId && column.isId()) continue;
            if (notNull) {
                sql.append(SqlSourceBuilder.getIfNotNull(column, column.getColumn() + ",", notEmpty));
                continue;
            }
            sql.append(column.getColumn() + ",");
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public static String insertValuesColumns(Class<?> entityClass, boolean skipId, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<trim prefix=\"VALUES (\" suffix=\")\" suffixOverrides=\",\">");
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (!column.isInsertable() || skipId && column.isId()) continue;
            if (notNull) {
                sql.append(SqlSourceBuilder.getIfNotNull(column, column.getColumnHolder() + ",", notEmpty));
                continue;
            }
            sql.append(column.getColumnHolder() + ",");
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public static String updateSetColumns(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        EntityColumn versionColumn = null;
        for (EntityColumn column : columnList) {
            if (column.getEntityField().isAnnotationPresent(Version.class)) {
                if (versionColumn != null) {
                    throw new VersionException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5,\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                versionColumn = column;
            }
            if (column.isId() || !column.isUpdatable()) continue;
            if (column == versionColumn) {
                Version version = versionColumn.getEntityField().getAnnotation(Version.class);
                String versionClass = version.nextVersion().getCanonicalName();
                sql.append(column.getColumn()).append(" = ${@org.aoju.bus.mapper.version.NextVersion@version(\"").append(versionClass).append("\", ").append(column.getProperty()).append(")},");
                continue;
            }
            if (notNull) {
                sql.append(SqlSourceBuilder.getIfNotNull(entityName, column, column.getColumnEqualsHolder(entityName) + ",", notEmpty));
                continue;
            }
            sql.append(column.getColumnEqualsHolder(entityName) + ",");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public static String wherePKColumns(Class<?> entityClass) {
        return SqlSourceBuilder.wherePKColumns(entityClass, false);
    }

    public static String wherePKColumns(Class<?> entityClass, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set<EntityColumn> columnList = EntityBuilder.getPKColumns(entityClass);
        for (EntityColumn column : columnList) {
            sql.append(" AND " + column.getColumnEqualsHolder());
        }
        if (useVersion) {
            sql.append(SqlSourceBuilder.whereVersion(entityClass));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String whereAllIfColumns(Class<?> entityClass, boolean empty) {
        return SqlSourceBuilder.whereAllIfColumns(entityClass, empty, false);
    }

    public static String whereAllIfColumns(Class<?> entityClass, boolean empty, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (useVersion && column.getEntityField().isAnnotationPresent(Version.class)) continue;
            sql.append(SqlSourceBuilder.getIfNotNull(column, " AND " + column.getColumnEqualsHolder(), empty));
        }
        if (useVersion) {
            sql.append(SqlSourceBuilder.whereVersion(entityClass));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String whereVersion(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        boolean hasVersion = false;
        String result = "";
        for (EntityColumn column : columnList) {
            if (!column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (hasVersion) {
                throw new VersionException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5,\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
            }
            hasVersion = true;
            result = " AND " + column.getColumnEqualsHolder();
        }
        return result;
    }

    public static String orderByDefault(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        String orderByClause = EntityBuilder.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append(" ORDER BY ");
            sql.append(orderByClause);
        }
        return sql.toString();
    }

    public static String selectColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"@org.aoju.bus.mapper.builder.OGNL@hasSelectColumns(_parameter)\">");
        sql.append("<foreach collection=\"_parameter.selectColumns\" item=\"selectColumn\" separator=\",\">");
        sql.append("${selectColumn}");
        sql.append("</foreach>");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append(SqlSourceBuilder.getAllColumns(entityClass));
        sql.append("</otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }

    public static String countColumn(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"@org.aoju.bus.mapper.builder.OGNL@hasCountColumn(_parameter)\">");
        sql.append("COUNT(${countColumn})");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append("COUNT(0)");
        sql.append("</otherwise>");
        sql.append("</choose>");
        sql.append("<if test=\"@org.aoju.bus.mapper.builder.OGNL@hasNoSelectColumns(_parameter)\">");
        sql.append(SqlSourceBuilder.getAllColumns(entityClass));
        sql.append("</if>");
        return sql.toString();
    }

    public static String orderBy(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"orderByClause != null\">");
        sql.append("order by ${orderByClause}");
        sql.append("</if>");
        String orderByClause = EntityBuilder.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append("<if test=\"orderByClause == null\">");
            sql.append("ORDER BY " + orderByClause);
            sql.append("</if>");
        }
        return sql.toString();
    }

    public static String forUpdate() {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"@org.aoju.bus.mapper.builder.OGNL@hasForUpdate(_parameter)\">");
        sql.append("FOR UPDATE");
        sql.append("</if>");
        return sql.toString();
    }

    public static String check(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"checkEntityClass\" value=\"@org.aoju.bus.mapper.builder.OGNL@checkEntityClass(_parameter, '");
        sql.append(entityClass.getCanonicalName());
        sql.append("')\"/>");
        return sql.toString();
    }

    public static String whereClause() {
        return "<if test=\"_parameter != null\"><where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\">\n    <if test=\"criteria.valid\">\n      ${@org.aoju.bus.mapper.builder.OGNL@andOr(criteria)}      <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              ${@org.aoju.bus.mapper.builder.OGNL@andOr(criterion)} ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              ${@org.aoju.bus.mapper.builder.OGNL@andOr(criterion)} ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              ${@org.aoju.bus.mapper.builder.OGNL@andOr(criterion)} ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              ${@org.aoju.bus.mapper.builder.OGNL@andOr(criterion)} ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where></if>";
    }

    public static String updateByWhereClause() {
        return "<where>\n  <foreach collection=\"condition.oredCriteria\" item=\"criteria\">\n    <if test=\"criteria.valid\">\n      ${@org.aoju.bus.mapper.builder.OGNL@andOr(criteria)}      <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              ${@org.aoju.bus.mapper.builder.OGNL@andOr(criterion)} ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              ${@org.aoju.bus.mapper.builder.OGNL@andOr(criterion)} ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              ${@org.aoju.bus.mapper.builder.OGNL@andOr(criterion)} ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              ${@org.aoju.bus.mapper.builder.OGNL@andOr(criterion)} ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>";
    }
}

