/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.notify.Provider;
import org.aoju.bus.notify.Registry;
import org.aoju.bus.notify.metric.Properties;
import org.aoju.bus.notify.provider.aliyun.AliyunSmsProperties;
import org.aoju.bus.notify.provider.aliyun.AliyunSmsProvider;
import org.aoju.bus.notify.provider.aliyun.AliyunVmsProperties;
import org.aoju.bus.notify.provider.aliyun.AliyunVmsProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkCropMsgProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkProperties;
import org.aoju.bus.notify.provider.netease.NeteaseAttachMsgProvider;
import org.aoju.bus.notify.provider.netease.NeteaseMsgProvider;
import org.aoju.bus.notify.provider.netease.NeteaseProperties;

public class NotifyProviderService {
    private static Map<Registry, Properties> NOTIFY_CACHE = new ConcurrentHashMap<Registry, Properties>();

    public static void register(Registry registry, Properties properties) {
        if (NOTIFY_CACHE.containsKey((Object)registry)) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u6821\u9a8c\u5668\uff1a" + registry.name());
        }
        NOTIFY_CACHE.putIfAbsent(registry, properties);
    }

    public static Provider get(Registry registry) {
        if (Registry.ALIYUN_SMS.equals((Object)registry)) {
            return new AliyunSmsProvider((AliyunSmsProperties)NOTIFY_CACHE.get((Object)registry));
        }
        if (Registry.ALIYUN_VMS.equals((Object)registry)) {
            return new AliyunVmsProvider((AliyunVmsProperties)NOTIFY_CACHE.get((Object)registry));
        }
        if (Registry.DINGTALK_CORP_MSG.equals((Object)registry)) {
            return new DingTalkCropMsgProvider((DingTalkProperties)NOTIFY_CACHE.get((Object)registry));
        }
        if (Registry.NETEASE_ATTACH_MSG.equals((Object)registry)) {
            return new NeteaseAttachMsgProvider((NeteaseProperties)NOTIFY_CACHE.get((Object)registry));
        }
        if (Registry.NETEASE_MSG.equals((Object)registry)) {
            return new NeteaseMsgProvider((NeteaseProperties)NOTIFY_CACHE.get((Object)registry));
        }
        return null;
    }
}

