/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class FeishuProvider
extends DefaultProvider {
    public FeishuProvider(Context context) {
        super(context, Registry.FEISHU);
    }

    public FeishuProvider(Context context, StateCache stateCache) {
        super(context, Registry.FEISHU, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback callback) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("app_id", (Object)this.context.getAppKey());
        requestObject.put("app_secret", (Object)this.context.getAppSecret());
        requestObject.put("grant_type", (Object)"authorization_code");
        requestObject.put("code", (Object)callback.getCode());
        String response = Httpx.post(this.source.accessToken(), requestObject.toJSONString(), "application/json");
        JSONObject jsonObject = JSON.parseObject((String)response);
        this.checkResponse(jsonObject);
        return AccToken.builder().accessToken(jsonObject.getString("access_token")).refreshToken(jsonObject.getString("refresh_token")).expireIn(jsonObject.getIntValue("expires_in")).tokenType(jsonObject.getString("token_type")).openId(jsonObject.getString("open_id")).build();
    }

    @Override
    protected Property getUserInfo(AccToken authToken) {
        String accessToken = authToken.getAccessToken();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        map.put("Authorization", "Bearer " + accessToken);
        String response = Httpx.get(this.source.userInfo(), null, map);
        JSONObject jsonObject = JSON.parseObject((String)response);
        return Property.builder().avatar(jsonObject.getString("AvatarUrl")).username(jsonObject.getString("Mobile")).email(jsonObject.getString("Email")).nickname("Name").build();
    }

    @Override
    public Message refresh(AccToken authToken) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("app_id", (Object)this.context.getAppKey());
        requestObject.put("app_secret", (Object)this.context.getAppSecret());
        requestObject.put("grant_type", (Object)"refresh_token");
        requestObject.put("refresh_token", (Object)authToken.getRefreshToken());
        String response = Httpx.post(this.source.refresh(), requestObject.toJSONString(), "application/json");
        JSONObject jsonObject = JSON.parseObject((String)response);
        this.checkResponse(jsonObject);
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(AccToken.builder().accessToken(jsonObject.getString("access_token")).refreshToken(jsonObject.getString("refresh_token")).expireIn(jsonObject.getIntValue("expires_in")).tokenType(jsonObject.getString("token_type")).openId(jsonObject.getString("open_id")).build()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("app_id", this.context.getAppKey()).queryParam("redirect_uri", FeishuProvider.urlEncode(this.context.getRedirectUri())).queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(JSONObject jsonObject) {
        if (jsonObject.getIntValue("code") != 0) {
            throw new AuthorizedException(jsonObject.getString("message"));
        }
    }
}

