/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpz;
import org.aoju.bus.http.magic.HttpResponse;
import org.aoju.bus.http.magic.PostBuilder;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class JdProvider
extends DefaultProvider {
    public JdProvider(Context context) {
        super(context, Registry.JD);
    }

    public JdProvider(Context context, StateCache stateCache) {
        super(context, Registry.JD, stateCache);
    }

    private static String md5(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(source.getBytes(Charset.UTF_8));
            StringBuilder sign = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                String hex = Integer.toHexString(bytes[i] & 0xFF);
                if (hex.length() == 1) {
                    sign.append("0");
                }
                sign.append(hex.toUpperCase());
            }
            return sign.toString();
        }
        catch (NoSuchAlgorithmException ignored) {
            throw new AuthorizedException(ignored.getMessage());
        }
    }

    @Override
    protected AccToken getAccessToken(Callback callback) {
        JSONObject object = null;
        try {
            HttpResponse response = ((PostBuilder)((PostBuilder)((PostBuilder)((PostBuilder)((PostBuilder)Httpz.post().url(this.source.accessToken())).addParams("app_key", this.context.getAppKey())).addParams("app_secret", this.context.getAppSecret())).addParams("grant_type", "authorization_code")).addParams("code", callback.getCode())).build().execute();
            object = JSONObject.parseObject((String)response.body().string());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).scope(object.getString("scope")).openId(object.getString("open_id")).build();
    }

    @Override
    protected Property getUserInfo(AccToken accToken) {
        JSONObject object = null;
        try {
            Builder urlBuilder = Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("app_key", this.context.getAppKey()).queryParam("method", "jingdong.user.getUserInfoByOpenId").queryParam("360buy_param_json", "{\"openId\":\"" + accToken.getOpenId() + "\"}").queryParam("timestamp", DateUtils.format(new Date())).queryParam("v", "2.0");
            urlBuilder.queryParam("sign", this.sign(urlBuilder.getReadParams()));
            HttpResponse response = ((PostBuilder)Httpz.post().url(urlBuilder.build(true))).build().execute();
            object = JSONObject.parseObject((String)response.body().string());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkResponse(object);
        JSONObject data = this.getUserDataJsonObject(object);
        return Property.builder().uuid(accToken.getOpenId()).username(data.getString("nickname")).nickname(data.getString("nickname")).avatar(data.getString("imageUrl")).gender(this.getRealGender(object)).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken oldToken) {
        JSONObject object = null;
        try {
            HttpResponse response = ((PostBuilder)((PostBuilder)((PostBuilder)((PostBuilder)((PostBuilder)Httpz.post().url(this.source.refresh())).addParams("app_key", this.context.getAppKey())).addParams("app_secret", this.context.getAppSecret())).addParams("grant_type", "refresh_token")).addParams("refresh_token", oldToken.getRefreshToken())).build().execute();
            object = JSONObject.parseObject((String)response.body().string());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkResponse(object);
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).scope(object.getString("scope")).openId(object.getString("open_id")).build()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("app_key", this.context.getAppKey()).queryParam("response_type", "code").queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "snsapi_base").queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"msg")) {
            throw new AuthorizedException(object.getString("msg"));
        }
        if (object.containsKey((Object)"error_response")) {
            throw new AuthorizedException(object.getJSONObject("error_response").getString("zh_desc"));
        }
    }

    private JSONObject getUserDataJsonObject(JSONObject object) {
        return object.getJSONObject("jingdong_user_getUserInfoByOpenId_response").getJSONObject("getuserinfobyappidandopenid_result").getJSONObject("data");
    }

    private String sign(Map<String, Object> params) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(params);
        String appSecret = this.context.getAppSecret();
        StringBuilder signBuilder = new StringBuilder(appSecret);
        for (Map.Entry entry : treeMap.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.isNotEmpty(name) || !StringUtils.isNotEmpty(value)) continue;
            signBuilder.append(name).append(value);
        }
        signBuilder.append(appSecret);
        try {
            return JdProvider.md5(signBuilder.toString());
        }
        catch (Exception e) {
            throw new AuthorizedException("build sign to jdMd5 error");
        }
    }
}

