/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class LinkedinProvider
extends DefaultProvider {
    public LinkedinProvider(Context context) {
        super(context, Registry.LINKEDIN);
    }

    public LinkedinProvider(Context context, StateCache stateCache) {
        super(context, Registry.LINKEDIN, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return this.getToken(this.accessTokenUrl(Callback2.getCode()));
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String accessToken = token.getAccessToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "api.linkedin.com");
        header.put("Connection", "Keep-Alive");
        header.put("Authorization", "Bearer " + accessToken);
        String response = Httpx.get(this.userInfoUrl(token), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        String userName = this.getUserName(object);
        String avatar = this.getAvatar(object);
        String email = this.getUserEmail(accessToken);
        return Property.builder().uuid(object.getString("id")).username(userName).nickname(userName).avatar(avatar).email(email).token(token).gender(Normal.Gender.UNKNOWN).source(this.source.toString()).build();
    }

    private String getUserName(JSONObject userInfoObject) {
        String firstName = userInfoObject.containsKey((Object)"localizedFirstName") ? userInfoObject.getString("localizedFirstName") : this.getUserName(userInfoObject, "firstName");
        String lastName = userInfoObject.containsKey((Object)"localizedLastName") ? userInfoObject.getString("localizedLastName") : this.getUserName(userInfoObject, "lastName");
        return firstName + " " + lastName;
    }

    private String getAvatar(JSONObject userInfoObject) {
        JSONArray displayImageElements;
        String avatar = null;
        JSONObject profilePictureObject = userInfoObject.getJSONObject("profilePicture");
        if (profilePictureObject.containsKey((Object)"displayImage~") && null != (displayImageElements = profilePictureObject.getJSONObject("displayImage~").getJSONArray("elements")) && displayImageElements.size() > 0) {
            JSONObject largestImageObj = displayImageElements.getJSONObject(displayImageElements.size() - 1);
            avatar = largestImageObj.getJSONArray("identifiers").getJSONObject(0).getString("identifier");
        }
        return avatar;
    }

    private String getUserEmail(String accessToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "api.linkedin.com");
        header.put("Connection", "Keep-Alive");
        header.put("Authorization", "Bearer " + accessToken);
        String url = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";
        String response = Httpx.get(url, null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        Object obj = JSONPath.eval((Object)object, (String)"$['elements'][0]['handle~']['emailAddress']");
        return null == obj ? null : (String)obj;
    }

    private String getUserName(JSONObject userInfoObject, String nameKey) {
        JSONObject firstNameObj = userInfoObject.getJSONObject(nameKey);
        JSONObject localizedObj = firstNameObj.getJSONObject("localized");
        JSONObject preferredLocaleObj = firstNameObj.getJSONObject("preferredLocale");
        String firstName = localizedObj.getString(preferredLocaleObj.getString("language") + "_" + preferredLocaleObj.getString("country"));
        return firstName;
    }

    @Override
    public Message refresh(AccToken oldToken) {
        String refreshToken = oldToken.getRefreshToken();
        if (StringUtils.isEmpty(refreshToken)) {
            throw new AuthorizedException(Builder.Status.UNSUPPORTED.getCode());
        }
        String refreshTokenUrl = this.refreshTokenUrl(refreshToken);
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getToken(refreshTokenUrl)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
    }

    private AccToken getToken(String accessTokenUrl) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "www.linkedin.com");
        String response = Httpx.get(accessTokenUrl, null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "r_liteprofile%20r_emailaddress%20w_member_social").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("projection", "(id,firstName,lastName,profilePicture(displayImage~:playableStreams))").build();
    }
}

