/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class QqProvider
extends DefaultProvider {
    public QqProvider(Context context) {
        super(context, Registry.QQ);
    }

    public QqProvider(Context context, StateCache stateCache) {
        super(context, Registry.QQ, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return this.getAuthToken(this.doGetAuthorizationCode(Callback2.getCode()));
    }

    @Override
    public Message refresh(AccToken token) {
        String response = Httpx.get(this.refreshTokenUrl(token.getRefreshToken()));
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String openId = this.getOpenId(token);
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        if (object.getIntValue("ret") != 0) {
            throw new AuthorizedException(object.getString("msg"));
        }
        String avatar = object.getString("figureurl_qq_2");
        if (StringUtils.isEmpty(avatar)) {
            avatar = object.getString("figureurl_qq_1");
        }
        String location = String.format("%s-%s", object.getString("province"), object.getString("city"));
        return Property.builder().username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(avatar).location(location).uuid(openId).gender(Normal.Gender.getGender(object.getString("gender"))).token(token).source(this.source.toString()).build();
    }

    private String getOpenId(AccToken token) {
        String response = Httpx.get(Builder.fromUrl("https://graph.qq.com/oauth2.0/me").queryParam("access_token", token.getAccessToken()).queryParam("unionid", this.context.isUnionId() ? 1 : 0).build());
        String removePrefix = StringUtils.replace(response, "callback(", "");
        String removeSuffix = StringUtils.replace(removePrefix, ");", "");
        String openId = StringUtils.trim(removeSuffix);
        JSONObject object = JSONObject.parseObject((String)openId);
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.get((Object)"error") + ":" + object.get((Object)"error_description"));
        }
        token.setOpenId(object.getString("openid"));
        if (object.containsKey((Object)"unionid")) {
            token.setUnionId(object.getString("unionid"));
        }
        return StringUtils.isEmpty(token.getUnionId()) ? token.getOpenId() : token.getUnionId();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("oauth_consumer_key", this.context.getAppKey()).queryParam("openid", token.getOpenId()).build();
    }

    private AccToken getAuthToken(String response) {
        Map<String, String> accessTokenObject = QqProvider.parseStringToMap(response);
        if (!accessTokenObject.containsKey("access_token") || accessTokenObject.containsKey("code")) {
            throw new AuthorizedException(accessTokenObject.get("msg"));
        }
        return AccToken.builder().accessToken(accessTokenObject.get("access_token")).expireIn(Integer.valueOf(accessTokenObject.get("expires_in"))).refreshToken(accessTokenObject.get("refresh_token")).build();
    }
}

