/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Props;

public final class Info {
    public static boolean isOpenOffice(XComponentContext context) {
        return "openoffice".equalsIgnoreCase(Info.getOfficeName(context));
    }

    public static boolean isLibreOffice(XComponentContext context) {
        return "libreoffice".equalsIgnoreCase(Info.getOfficeName(context));
    }

    public static String getOfficeName(XComponentContext context) {
        return Info.getConfig(context, "ooName").orElse(null);
    }

    public static String getOfficeVersionLong(XComponentContext context) {
        return Info.getConfig(context, "ooSetupVersionAboutBox").orElse(null);
    }

    public static String getOfficeVersionShort(XComponentContext context) {
        return Info.getConfig(context, "ooSetupVersion").orElse(null);
    }

    public static int compareVersions(String version1, String version2, int length) {
        if (StringUtils.isEmpty(version1) && StringUtils.isEmpty(version2)) {
            return 0;
        }
        if (StringUtils.isEmpty(version1)) {
            return -1;
        }
        if (StringUtils.isEmpty(version2)) {
            return 1;
        }
        String[] numbers1 = Info.normalizeVersion(version1, length).split("\\.");
        String[] numbers2 = Info.normalizeVersion(version2, length).split("\\.");
        for (int i = 0; i < numbers1.length; ++i) {
            if (Integer.valueOf(numbers1[i]) < Integer.valueOf(numbers2[i])) {
                return -1;
            }
            if (Integer.valueOf(numbers1[i]) <= Integer.valueOf(numbers2[i])) continue;
            return 1;
        }
        return 0;
    }

    private static String normalizeVersion(String version, int length) {
        ArrayList<String> numbers = new ArrayList<String>(Arrays.asList(version.split("\\.")));
        while (numbers.size() < length) {
            numbers.add("0");
        }
        return numbers.stream().collect(Collectors.joining("."));
    }

    public static Optional<String> getConfig(XComponentContext context, String propName) {
        for (String nodePath : Builder.NODE_PATHS) {
            Optional<Object> info = Info.getConfig(context, nodePath, propName);
            if (!info.isPresent()) continue;
            return info.map(String.class::cast);
        }
        return Optional.empty();
    }

    public static Optional<Object> getConfig(XComponentContext context, String nodePath, String propName) {
        return Info.getConfigProperties(context, nodePath).map(props -> Props.getProperty(props, propName)).orElse(Optional.empty());
    }

    public static Optional<XPropertySet> getConfigProperties(XComponentContext context, String nodePath) {
        XMultiServiceFactory provider = Lo.createInstanceMCF(context, XMultiServiceFactory.class, "com.sun.star.configuration.ConfigurationProvider");
        if (provider == null) {
            Logger.debug("Could not create configuration provider", new Object[0]);
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(Lo.qi(XPropertySet.class, provider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", (Object[])Props.makeProperties("nodepath", nodePath))));
        }
        catch (Exception ex) {
            Logger.debug("Unable to access config properties for: " + nodePath, new Object[]{ex});
            return Optional.empty();
        }
    }

    public static boolean isDocumentType(XComponent document, String documentType) {
        return Lo.qi(XServiceInfo.class, document).supportsService(documentType);
    }
}

