/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class PriorityQueue<E>
extends java.util.PriorityQueue<E> {
    private static final long serialVersionUID = 1L;
    private int capacity;
    private Comparator<? super E> comparator;

    public PriorityQueue(int capacity) {
        this(capacity, null);
    }

    public PriorityQueue(int capacity, Comparator<? super E> comparator) {
        super(capacity, (o1, o2) -> {
            int cResult;
            if (comparator != null) {
                cResult = comparator.compare(o1, o2);
            } else {
                Comparable o1c = (Comparable)o1;
                cResult = o1c.compareTo(o2);
            }
            return -cResult;
        });
        this.capacity = capacity;
        this.comparator = comparator;
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this.capacity) {
            Object head = this.peek();
            if (this.comparator().compare(e, head) <= 0) {
                return true;
            }
            this.poll();
        }
        return super.offer(e);
    }

    public boolean addAll(E[] c) {
        return this.addAll(Arrays.asList(c));
    }

    public ArrayList<E> toList() {
        ArrayList list = new ArrayList(this);
        Collections.sort(list, this.comparator);
        return list;
    }

    @Override
    public Iterator<E> iterator() {
        return this.toList().iterator();
    }
}

