/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.digest.mac.MacEngine;
import org.aoju.bus.crypto.digest.mac.MacEngineFactory;

public class HMac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MacEngine engine;

    public HMac(String algorithm) {
        this(algorithm, (SecretKey)null);
    }

    public HMac(String algorithm, byte[] key) {
        this(algorithm, new SecretKeySpec(key, algorithm));
    }

    public HMac(String algorithm, SecretKey key) {
        this(MacEngineFactory.createEngine(algorithm, key));
    }

    public HMac(MacEngine engine) {
        this.engine = engine;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StringUtils.bytes((CharSequence)data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexUtils.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws InstrumentException {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoUtils.close(in);
        }
    }

    public String digestHex(File file) {
        return HexUtils.encodeHexStr(this.digest(file));
    }

    public byte[] digest(byte[] data) {
        return this.digest(new ByteArrayInputStream(data), -1);
    }

    public String digestHex(byte[] data) {
        return HexUtils.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexUtils.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        return this.engine.digest(data, bufferLength);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtils.encodeHexStr(this.digest(data, bufferLength));
    }
}

