/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.forest.archive;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.forest.Builder;
import org.aoju.bus.forest.Complex;
import org.aoju.bus.forest.algorithm.Key;
import org.aoju.bus.forest.provider.DecryptorProvider;
import org.aoju.bus.forest.provider.EntryDecryptorProvider;
import org.aoju.bus.forest.streams.AlwaysOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipDecryptorProvider
extends EntryDecryptorProvider<ZipArchiveEntry>
implements DecryptorProvider {
    private final int level;

    public ZipDecryptorProvider(DecryptorProvider xEncryptor) {
        this(xEncryptor, (Complex<ZipArchiveEntry>)null);
    }

    public ZipDecryptorProvider(DecryptorProvider decryptorProvider, Complex<ZipArchiveEntry> filter) {
        this(decryptorProvider, 8, filter);
    }

    public ZipDecryptorProvider(DecryptorProvider xEncryptor, int level) {
        this(xEncryptor, level, null);
    }

    public ZipDecryptorProvider(DecryptorProvider decryptorProvider, int level, Complex<ZipArchiveEntry> filter) {
        super(decryptorProvider, filter);
        this.level = level;
    }

    @Override
    public void decrypt(Key key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.decrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(Key key, InputStream in, OutputStream out) throws IOException {
        ZipArchiveInputStream zis = null;
        ZipArchiveOutputStream zos = null;
        try {
            ZipArchiveEntry entry;
            zis = new ZipArchiveInputStream(in);
            zos = new ZipArchiveOutputStream(out);
            zos.setLevel(this.level);
            AlwaysOutputStream nos = new AlwaysOutputStream((OutputStream)zos);
            while ((entry = zis.getNextZipEntry()) != null) {
                if (entry.isDirectory()) continue;
                zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(entry.getName()));
                DecryptorProvider decryptor = this.on(entry) ? this : this.xNopDecryptor;
                try (OutputStream eos = decryptor.decrypt(key, nos);){
                    Builder.transfer((InputStream)zis, eos);
                }
                zos.closeArchiveEntry();
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            Builder.close(zis);
            Builder.close(zos);
            throw throwable;
        }
        Builder.close((Closeable)zis);
        Builder.close((Closeable)zos);
    }
}

