/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.common.linux;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Config;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.hardware.CentralProcessor;

public class ProcUtils {
    public static final String CPUINFO = "/cpuinfo";
    public static final String STAT = "/stat";
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private static Supplier<String> proc = Memoizer.memoize(ProcUtils::queryProcConfig, TimeUnit.HOURS.toNanos(1L));

    private ProcUtils() {
    }

    public static String getProcPath() {
        return proc.get();
    }

    private static String queryProcConfig() {
        String procPath = Config.get("oshi.util.proc.path", "/proc");
        procPath = '/' + procPath.replaceAll("/$|^/", "");
        if (!new File(procPath).exists()) {
            throw new Config.PropertyException("oshi.util.proc.path", "The path does not exist");
        }
        return procPath;
    }

    public static double getSystemUptimeSeconds() {
        String uptime = Builder.getStringFromFile(ProcUtils.getProcPath() + "/uptime");
        int spaceIndex = uptime.indexOf(32);
        try {
            if (spaceIndex < 0) {
                return 0.0;
            }
            return Double.parseDouble(uptime.substring(0, spaceIndex));
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    public static long[] readSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        List<String> procStat = Builder.readFile(ProcUtils.getProcPath() + STAT);
        if (procStat.isEmpty()) {
            return ticks;
        }
        String tickStr = procStat.get(0);
        String[] tickArr = Builder.whitespaces.split(tickStr);
        if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
            return ticks;
        }
        for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
            ticks[i] = Builder.parseLongOrDefault(tickArr[i + 1], 0L);
        }
        return ticks;
    }

    public static File[] getPidFiles() {
        File procdir = new File(ProcUtils.getProcPath());
        File[] pids = procdir.listFiles(f -> DIGITS.matcher(f.getName()).matches());
        return pids != null ? pids : new File[]{};
    }
}

