/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.freebsd;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.hardware.AbstractDisplay;
import org.aoju.bus.health.hardware.Display;
import org.aoju.bus.logger.Logger;

public class FreeBsdDisplay
extends AbstractDisplay {
    public FreeBsdDisplay(byte[] edid) {
        super(edid);
        Logger.debug("Initialized FreeBSDDisplay", new Object[0]);
    }

    public static Display[] getDisplays() {
        List<String> xrandr = Command.runNative("xrandr --verbose");
        if (xrandr.isEmpty()) {
            return new Display[0];
        }
        ArrayList<FreeBsdDisplay> displays = new ArrayList<FreeBsdDisplay>();
        StringBuilder sb = null;
        for (String s : xrandr) {
            if (s.contains("EDID")) {
                sb = new StringBuilder();
                continue;
            }
            if (sb == null) continue;
            sb.append(s.trim());
            if (sb.length() < 256) continue;
            String edidStr = sb.toString();
            Logger.debug("Parsed EDID: {}", edidStr);
            byte[] edid = Builder.hexStringToByteArray(edidStr);
            if (edid.length >= 128) {
                displays.add(new FreeBsdDisplay(edid));
            }
            sb = null;
        }
        return displays.toArray(new Display[0]);
    }
}

