/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.io.DelegateSource;
import org.aoju.bus.core.io.Sink;
import org.aoju.bus.core.io.Source;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.http.Builder;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.accord.StreamAllocation;
import org.aoju.bus.http.bodys.RealResponseBody;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.metric.Interceptor;
import org.aoju.bus.http.metric.http.ErrorCode;
import org.aoju.bus.http.metric.http.Http2Connection;
import org.aoju.bus.http.metric.http.Http2Stream;
import org.aoju.bus.http.metric.http.HttpCodec;
import org.aoju.bus.http.metric.http.HttpHeaders;
import org.aoju.bus.http.metric.http.RequestLine;
import org.aoju.bus.http.metric.http.StatusLine;

public final class Http2Codec
implements HttpCodec {
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS = Builder.immutableList("Connection", "Host", "Keep-Alive", "Proxy-Connection", "te", "Transfer-Encoding", "Encoding", "Upgrade", ":method", ":path", ":scheme", ":authority");
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS = Builder.immutableList("Connection", "Host", "Keep-Alive", "Proxy-Connection", "te", "Transfer-Encoding", "Encoding", "Upgrade");
    final StreamAllocation streamAllocation;
    private final Interceptor.Chain chain;
    private final Http2Connection connection;
    private final Protocol protocol;
    private Http2Stream stream;

    public Http2Codec(Httpd client, Interceptor.Chain chain, StreamAllocation streamAllocation, Http2Connection connection) {
        this.chain = chain;
        this.streamAllocation = streamAllocation;
        this.connection = connection;
        this.protocol = client.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    public static List<HttpHeaders> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<HttpHeaders> result = new ArrayList<HttpHeaders>(headers.size() + 4);
        result.add(new HttpHeaders(HttpHeaders.TARGET_METHOD, request.method()));
        result.add(new HttpHeaders(HttpHeaders.TARGET_PATH, RequestLine.requestPath(request.url())));
        String host = request.header("Host");
        if (host != null) {
            result.add(new HttpHeaders(HttpHeaders.TARGET_AUTHORITY, host));
        }
        result.add(new HttpHeaders(HttpHeaders.TARGET_SCHEME, request.url().scheme()));
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            ByteString name = ByteString.encodeUtf8(headers.name(i).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name.utf8())) continue;
            result.add(new HttpHeaders(name, headers.value(i)));
        }
        return result;
    }

    public static Response.Builder readHttp2HeadersList(Headers headerBlock, Protocol protocol) throws IOException {
        StatusLine statusLine = null;
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headerBlock.size();
        for (int i = 0; i < size; ++i) {
            String name = headerBlock.name(i);
            String value = headerBlock.value(i);
            if (name.equals(":status")) {
                statusLine = StatusLine.parse("HTTP/1.1 " + value);
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
            Builder.instance.addLenient(headersBuilder, name, value);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request.body() != null;
        List<HttpHeaders> requestHeaders = Http2Codec.http2HeadersList(request);
        this.stream = this.connection.newStream(requestHeaders, hasRequestBody);
        this.stream.readTimeout().timeout(this.chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout(this.chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() throws IOException {
        this.connection.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        Headers headers = this.stream.takeHeaders();
        Response.Builder responseBuilder = Http2Codec.readHttp2HeadersList(headers, this.protocol);
        if (expectContinue && Builder.instance.code(responseBuilder) == 100) {
            return null;
        }
        return responseBuilder;
    }

    @Override
    public ResponseBody openResponseBody(Response response) {
        this.streamAllocation.eventListener.responseBodyStart(this.streamAllocation.call);
        String contentType = response.header("Content-Type");
        long contentLength = HttpHeaders.contentLength(response);
        StreamFinishingSource source = new StreamFinishingSource(this.stream.getSource());
        return new RealResponseBody(contentType, contentLength, IoUtils.buffer(source));
    }

    @Override
    public void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    class StreamFinishingSource
    extends DelegateSource {
        boolean completed;
        long bytesRead;

        StreamFinishingSource(Source delegate) {
            super(delegate);
            this.completed = false;
            this.bytesRead = 0L;
        }

        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            try {
                long read = this.delegate().read(sink, byteCount);
                if (read > 0L) {
                    this.bytesRead += read;
                }
                return read;
            }
            catch (IOException e) {
                this.endOfInput(e);
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.endOfInput(null);
        }

        private void endOfInput(IOException e) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            Http2Codec.this.streamAllocation.streamFinished(false, Http2Codec.this, this.bytesRead, e);
        }
    }
}

