/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.dingtalk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.notify.AbstractProvider;
import org.aoju.bus.notify.magic.Response;
import org.aoju.bus.notify.provider.dingtalk.DingTalkCropMsgTemplate;
import org.aoju.bus.notify.provider.dingtalk.DingTalkProperties;

public class DingTalkCropMsgProvider
extends AbstractProvider<DingTalkCropMsgTemplate, DingTalkProperties> {
    private static final String SUCCESS_RESULT = "200";
    private static final String TOKEN_API = "https://oapi.dingtalk.com/gettoken";
    private static final String NOTIFY_API = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    private AtomicReference<String> accessToken = new AtomicReference();
    private long refreshTokenTime;
    private long tokenTimeOut = Duration.ofSeconds(7000L).toMillis();

    public DingTalkCropMsgProvider(DingTalkProperties properties) {
        super(properties);
    }

    @Override
    public Response send(DingTalkCropMsgTemplate template) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("access_token", template.getToken());
        param.put("agent_id", template.getAgentId());
        param.put("msg", template.getMsg());
        if (StringUtils.isNotBlank(template.getUserIdList())) {
            param.put("userid_list", template.getUserIdList());
        }
        if (StringUtils.isNotBlank(template.getDeptIdList())) {
            param.put("dept_id_list", template.getDeptIdList());
        }
        param.put("to_all_user", template.isToAllUser());
        String response = Httpx.post(NOTIFY_API, param);
        JSONObject object = JSON.parseObject((String)response);
        return ((Response.ResponseBuilder)((Response.ResponseBuilder)Response.builder().result(SUCCESS_RESULT.equals(object.getString("errcode")))).desc(object.getString("errmsg"))).build();
    }

    private String getToken() {
        if (System.currentTimeMillis() - this.refreshTokenTime > this.tokenTimeOut || this.accessToken.get() == null) {
            return this.requestToken();
        }
        return this.accessToken.get();
    }

    private String requestToken() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("corpid", ((DingTalkProperties)this.properties).getAppKey());
        paramMap.put("corpsecret", ((DingTalkProperties)this.properties).getAppSecret());
        String response = Httpx.get(TOKEN_API, paramMap);
        JSONObject object = JSON.parseObject((String)response);
        if (SUCCESS_RESULT.equals(object.getString("errcode"))) {
            String token = object.getString("access_token");
            this.refreshTokenTime = System.currentTimeMillis();
            this.accessToken.set(token);
            return token;
        }
        Logger.error("\u83b7\u53d6\u9489\u9489token\u5931\u8d25\uff1a{}", object.getString("errmsg"));
        return null;
    }

    public void setAccessToken(AtomicReference<String> accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshTokenTime(long refreshTokenTime) {
        this.refreshTokenTime = refreshTokenTime;
    }

    public void setTokenTimeOut(long tokenTimeOut) {
        this.tokenTimeOut = tokenTimeOut;
    }
}

