/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class PinterestProvider
extends DefaultProvider {
    private static final String FAILURE = "failure";

    public PinterestProvider(Context context) {
        super(context, Registry.PINTEREST);
    }

    public PinterestProvider(Context context, StateCache stateCache) {
        super(context, Registry.PINTEREST, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject accessTokenObject = JSONObject.parseObject((String)this.doPostAuthorizationCode(Callback2.getCode()));
        this.checkResponse(accessTokenObject);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).tokenType(accessTokenObject.getString("token_type")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String userinfoUrl = this.userInfoUrl(token);
        JSONObject object = JSONObject.parseObject((String)Httpx.get(userinfoUrl));
        this.checkResponse(object);
        JSONObject userObj = object.getJSONObject("data");
        return Property.builder().uuid(userObj.getString("id")).avatar(this.getAvatarUrl(userObj)).username(userObj.getString("username")).nickname(userObj.getString("first_name") + " " + userObj.getString("last_name")).gender(Normal.Gender.UNKNOWN).remark(userObj.getString("bio")).token(token).source(this.source.toString()).build();
    }

    private String getAvatarUrl(JSONObject userObj) {
        JSONObject jsonObject = userObj.getJSONObject("image");
        if (Objects.isNull(jsonObject)) {
            return null;
        }
        return jsonObject.getJSONObject("60x60").getString("url");
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "read_public").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("fields", "id,username,first_name,last_name,bio,image").build();
    }

    private void checkResponse(JSONObject object) {
        if (!object.containsKey((Object)"status") && FAILURE.equals(object.getString("status"))) {
            throw new AuthorizedException(object.getString("message"));
        }
    }
}

