/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter.text;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import java.io.File;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Write;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;

public class DocumentInserterFilter
implements Filter {
    private final File documentToInsert;

    public DocumentInserterFilter(File document) {
        this.documentToInsert = document;
    }

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            this.insertDocument(document);
        }
        chain.doFilter(context, document);
    }

    private void insertDocument(XComponent document) throws Exception {
        XTextDocument docText = Write.getTextDoc(document);
        XTextCursor textCursor = docText.getText().createTextCursor();
        textCursor.gotoEnd(false);
        XDocumentInsertable insertable = Lo.qi(XDocumentInsertable.class, textCursor);
        insertable.insertDocumentFromURL(Builder.toUrl(this.documentToInsert), new PropertyValue[0]);
    }
}

