/*********************************************************************************
 *                                                                               *
 * The MIT License                                                               *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.core.lang;

/**
 * Header 常量
 *
 * @author Kimi Liu
 * @version 5.8.2
 * @since JDK 1.8+
 */
public class Header {

    /**
     * The header Accept
     */
    public static final String ACCEPT = "Accept";
    /**
     * The header Accept-Charset
     */
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    /**
     * The header Accept-Encoding
     */
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    /**
     * The header Accept-Language
     */
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    /**
     * The header Accept-Ranges
     */
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    /**
     * The header Age
     */
    public static final String AGE = "Age";
    /**
     * The header Allow
     */
    public static final String ALLOW = "Allow";
    /**
     * The header Expires
     */
    public static final String EXPIRES = "Expires";
    /**
     * The header Cookie
     */
    public static final String COOKIE = "Cookie";
    /**
     * The header Cache-Control
     */
    public static final String CACHE_CONTROL = "Cache-Control";
    /**
     * The header Connection
     */
    public static final String CONNECTION = "Connection";
    /**
     * The header Content-Encoding
     */
    public static final String CONTENT_ENCODING = "Content-Encoding";
    /**
     * The header Content-Language
     */
    public static final String CONTENT_LANGUAGE = "Content-Language";
    /**
     * The header Content-Length
     */
    public static final String CONTENT_LENGTH = "Content-Length";
    /**
     * The header Content-Location
     */
    public static final String CONTENT_LOCATION = "Content-Location";
    /**
     * The header Content-MD5
     */
    public static final String CONTENT_MD5 = "Content-MD5";
    /**
     * The header Content-Range
     */
    public static final String CONTENT_RANGE = "Content-Range";
    /**
     * The header Content-Type
     */
    public static final String CONTENT_TYPE = "Content-Type";
    /**
     * The header Content-Disposition
     */
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    /**
     * The header User-Agent
     */
    public static final String USER_AGENT = "User-Agent";
    /**
     * The header Transfer-Encoding
     */
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    /**
     * The header Host
     */
    public static final String HOST = "Host";
    /**
     * The header Keep-Alive
     */
    public static final String KEEP_ALIVE = "Keep-Alive";
    /**
     * The header Proxy-Connection
     */
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    /**
     * The header WWW-Authenticate
     */
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    /**
     * The header Proxy-Authenticate
     */
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    /**
     * The header Httpd-Preemptive
     */
    public static final String HTTPD_PREEMPTIVE = "Httpd-Preemptive";
    /**
     * The header te
     */
    public static final String TE = "te";
    /**
     * The header Encoding
     */
    public static final String ENCODING = "Encoding";
    /**
     * The header Upgrade
     */
    public static final String UPGRADE = "Upgrade";
    /**
     * The header If-Modified-Since
     */
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    /**
     * The header If-None-Match
     */
    public static final String IF_NONE_MATCH = "If-None-Match";
    /**
     * The header Sec-WebSocket-Key
     */
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    /**
     * The header Sec-WebSocket-Version
     */
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";

}
