/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.util.Scanner;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;

public class Console {
    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.log(e, e.getMessage(), new Object[0]);
        } else {
            Console.log("{}", obj);
        }
    }

    public static void log(String template, Object ... values) {
        Console.log(null, template, values);
    }

    public static void log(Throwable t, String template, Object ... values) {
        if (null != t) {
            t.printStackTrace();
            System.out.flush();
        }
    }

    public static void print(Object obj) {
        Console.print("{}", obj);
    }

    public static void print(String template, Object ... values) {
        System.out.println(StringUtils.format(template, values));
    }

    public static void printProgress(char showChar, int len) {
        Console.print("{}{}", "\r", StringUtils.repeat(showChar, len));
    }

    public static void printProgress(char showChar, int totalLen, double rate) {
        Assert.isTrue(rate >= 0.0 && rate <= 1.0, "Rate must between 0 and 1 (both include)", new Object[0]);
        Console.printProgress(showChar, (int)((double)totalLen * rate));
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.error(e, e.getMessage(), new Object[0]);
        } else {
            Console.error("{}", obj);
        }
    }

    public static void error(String template, Object ... values) {
        Console.error(null, template, values);
    }

    public static void error(Throwable t, String template, Object ... values) {
        System.err.println(StringUtils.format(template, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    public static String input() {
        return Console.scanner().next();
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String where() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String fileName = stackTraceElement.getFileName();
        Integer lineNumber = stackTraceElement.getLineNumber();
        return String.format("%s.%s(%s:%s)", className, methodName, fileName, lineNumber);
    }

    public static Integer lineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }
}

