/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.loader.Filter;
import org.aoju.bus.core.loader.Filters;
import org.aoju.bus.core.loader.Loader;
import org.aoju.bus.core.loader.ResourceLoader;
import org.aoju.bus.core.utils.UriUtils;

public class JarLoader
extends ResourceLoader
implements Loader {
    private final URL context;
    private final JarFile jarFile;

    public JarLoader(File file) throws IOException {
        this(new URL("jar:" + file.toURI().toURL() + "!/"), new JarFile(file));
    }

    public JarLoader(URL jarURL) throws IOException {
        this(jarURL, ((JarURLConnection)jarURL.openConnection()).getJarFile());
    }

    public JarLoader(URL context, JarFile jarFile) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (jarFile == null) {
            throw new IllegalArgumentException("jarFile must not be null");
        }
        this.context = context;
        this.jarFile = jarFile;
    }

    @Override
    public Enumeration<Resource> load(String path, boolean recursively, Filter filter) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return new Enumerator(this.context, this.jarFile, path, recursively, filter != null ? filter : Filters.ALWAYS);
    }

    private static class Enumerator
    extends ResourceLoader.ResourceEnumerator
    implements Enumeration<Resource> {
        private final URL context;
        private final String path;
        private final String folder;
        private final boolean recursively;
        private final Filter filter;
        private final Enumeration<JarEntry> entries;

        Enumerator(URL context, JarFile jarFile, String path, boolean recursively, Filter filter) {
            this.context = context;
            this.path = path;
            this.folder = path.endsWith("/") || path.length() == 0 ? path : path + "/";
            this.recursively = recursively;
            this.filter = filter;
            this.entries = jarFile.entries();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next != null) {
                return true;
            }
            while (this.entries.hasMoreElements()) {
                String name;
                JarEntry jarEntry = this.entries.nextElement();
                if (jarEntry.isDirectory() || !(name = jarEntry.getName()).equals(this.path) && (!this.recursively || !name.startsWith(this.folder)) && (this.recursively || !name.startsWith(this.folder) || name.indexOf("/", this.folder.length()) >= 0)) continue;
                try {
                    URL url = new URL(this.context, UriUtils.encodePath(name, Charset.UTF_8));
                    if (!this.filter.filtrate(name, url)) continue;
                    this.next = new UriResource(url, name);
                    return true;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return false;
        }
    }
}

