/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.io.FastByteArray;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.KeyType;
import org.aoju.bus.crypto.asymmetric.Safety;

public class Asymmetric
extends Safety<Asymmetric> {
    protected Cipher cipher;
    protected int encryptBlockSize = -1;
    protected int decryptBlockSize = -1;

    public Asymmetric(String algorithm) {
        this(algorithm, (byte[])null, null);
    }

    public Asymmetric(String algorithm, String privateKey, String publicKey) {
        this(algorithm, Base64.decode(privateKey), Base64.decode(publicKey));
    }

    public Asymmetric(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, Builder.generatePrivateKey(algorithm, privateKey), Builder.generatePublicKey(algorithm, publicKey));
    }

    public Asymmetric(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public int getEncryptBlockSize() {
        return this.encryptBlockSize;
    }

    public void setEncryptBlockSize(int encryptBlockSize) {
        this.encryptBlockSize = encryptBlockSize;
    }

    public int getDecryptBlockSize() {
        return this.decryptBlockSize;
    }

    public void setDecryptBlockSize(int decryptBlockSize) {
        this.decryptBlockSize = decryptBlockSize;
    }

    @Override
    public Asymmetric init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super.init(algorithm, privateKey, publicKey);
        this.initCipher();
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize22;
            this.cipher.init(1, key);
            if (this.encryptBlockSize < 0 && (blockSize22 = this.cipher.getBlockSize()) > 0) {
                this.encryptBlockSize = blockSize22;
            }
            byte[] blockSize22 = this.doFinal(data, this.encryptBlockSize < 0 ? data.length : this.encryptBlockSize);
            return blockSize22;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize22;
            this.cipher.init(2, key);
            if (this.decryptBlockSize < 0 && (blockSize22 = this.cipher.getBlockSize()) > 0) {
                this.decryptBlockSize = blockSize22;
            }
            byte[] blockSize22 = this.doFinal(data, this.decryptBlockSize < 0 ? data.length : this.decryptBlockSize);
            return blockSize22;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Cipher getClipher() {
        return this.cipher;
    }

    protected void initCipher() {
        this.cipher = Builder.createCipher(this.algorithm);
    }

    private byte[] doFinal(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        if (dataLength <= maxBlockSize) {
            return this.cipher.doFinal(data, 0, dataLength);
        }
        return this.doFinalWithBlock(data, maxBlockSize);
    }

    private byte[] doFinalWithBlock(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        FastByteArray out = new FastByteArray();
        int offSet = 0;
        int remainLength = dataLength;
        while (remainLength > 0) {
            int blockSize = Math.min(remainLength, maxBlockSize);
            out.write(this.cipher.doFinal(data, offSet, blockSize));
            remainLength = dataLength - (offSet += blockSize);
        }
        return out.toByteArray();
    }
}

