/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.math.BigInteger;
import java.util.Random;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class SM2Engine {
    private final Digest digest;
    private boolean forEncryption;
    private ECKeyParameters ecKey;
    private ECDomainParameters ecParams;
    private int curveLength;
    private Random random;
    private SM2Mode mode;

    public SM2Engine() {
        this((Digest)new SM3Digest());
    }

    public SM2Engine(SM2Mode mode) {
        this((Digest)new SM3Digest(), mode);
    }

    public SM2Engine(Digest digest) {
        this(digest, null);
    }

    public SM2Engine(Digest digest, SM2Mode mode) {
        this.digest = digest;
        this.mode = ObjectUtils.defaultIfNull(mode, SM2Mode.C1C3C2);
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.ecKey = (ECKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.ecKey = (ECKeyParameters)param;
        }
        this.ecParams = this.ecKey.getParameters();
        if (forEncryption) {
            ECPoint ecPoint = ((ECPublicKeyParameters)this.ecKey).getQ().multiply(this.ecParams.getH());
            if (ecPoint.isInfinity()) {
                throw new IllegalArgumentException("invalid key: [h]Q at infinity");
            }
            if (null == this.random) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        this.curveLength = (this.ecParams.getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.forEncryption) {
            return this.encrypt(in, inOff, inLen);
        }
        return this.decrypt(in, inOff, inLen);
    }

    public SM2Engine setMode(SM2Mode mode) {
        this.mode = mode;
        return this;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private byte[] encrypt(byte[] in, int inOff, int inLen) {
        ECPoint kPB;
        byte[] c1;
        byte[] c2 = new byte[inLen];
        System.arraycopy(in, inOff, c2, 0, c2.length);
        ECMultiplier multiplier = this.createBasePointMultiplier();
        do {
            BigInteger k = this.nextK();
            c1 = multiplier.multiply(this.ecParams.getG(), k).normalize().getEncoded(false);
            kPB = ((ECPublicKeyParameters)this.ecKey).getQ().multiply(k).normalize();
            this.kdf(kPB, c2);
        } while (this.notEncrypted(c2, in, inOff));
        byte[] c3 = new byte[this.digest.getDigestSize()];
        this.addFieldElement(kPB.getAffineXCoord());
        this.digest.update(in, inOff, inLen);
        this.addFieldElement(kPB.getAffineYCoord());
        this.digest.doFinal(c3, 0);
        if (this.mode == SM2Mode.C1C3C2) {
            return Arrays.concatenate((byte[])c1, (byte[])c3, (byte[])c2);
        }
        return Arrays.concatenate((byte[])c1, (byte[])c2, (byte[])c3);
    }

    private byte[] decrypt(byte[] in, int inOff, int inLen) {
        byte[] c1 = new byte[this.curveLength * 2 + 1];
        System.arraycopy(in, inOff, c1, 0, c1.length);
        ECPoint c1P = this.ecParams.getCurve().decodePoint(c1);
        if (c1P.multiply(this.ecParams.getH()).isInfinity()) {
            throw new InstrumentException("[h]C1 at infinity");
        }
        c1P = c1P.multiply(((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        int digestSize = this.digest.getDigestSize();
        byte[] c2 = new byte[inLen - c1.length - digestSize];
        if (SM2Mode.C1C3C2 == this.mode) {
            System.arraycopy(in, inOff + c1.length + digestSize, c2, 0, c2.length);
        } else {
            System.arraycopy(in, inOff + c1.length, c2, 0, c2.length);
        }
        this.kdf(c1P, c2);
        byte[] c3 = new byte[digestSize];
        this.addFieldElement(c1P.getAffineXCoord());
        this.digest.update(c2, 0, c2.length);
        this.addFieldElement(c1P.getAffineYCoord());
        this.digest.doFinal(c3, 0);
        int check = 0;
        for (int i = 0; i != c3.length; ++i) {
            check |= c3[i] ^ in[inOff + c1.length + (SM2Mode.C1C3C2 == this.mode ? 0 : c2.length) + i];
        }
        Arrays.fill((byte[])c1, (byte)0);
        Arrays.fill((byte[])c3, (byte)0);
        if (check != 0) {
            Arrays.fill((byte[])c2, (byte)0);
            throw new InstrumentException("invalid cipher text");
        }
        return c2;
    }

    private boolean notEncrypted(byte[] encData, byte[] in, int inOff) {
        for (int i = 0; i != encData.length; ++i) {
            if (encData[i] == in[inOff + i]) continue;
            return false;
        }
        return true;
    }

    private void kdf(ECPoint c1, byte[] encData) {
        Digest digest = this.digest;
        int digestSize = digest.getDigestSize();
        byte[] buf = new byte[Math.max(4, digestSize)];
        int off = 0;
        Memoable memo = null;
        Memoable copy = null;
        if (digest instanceof Memoable) {
            this.addFieldElement(c1.getAffineXCoord());
            this.addFieldElement(c1.getAffineYCoord());
            memo = (Memoable)digest;
            copy = memo.copy();
        }
        int ct = 0;
        while (off < encData.length) {
            if (memo != null) {
                memo.reset(copy);
            } else {
                this.addFieldElement(c1.getAffineXCoord());
                this.addFieldElement(c1.getAffineYCoord());
            }
            Pack.intToBigEndian((int)(++ct), (byte[])buf, (int)0);
            digest.update(buf, 0, 4);
            digest.doFinal(buf, 0);
            int xorLen = Math.min(digestSize, encData.length - off);
            this.xor(encData, buf, off, xorLen);
            off += xorLen;
        }
    }

    private void xor(byte[] data, byte[] kdfOut, int dOff, int dRemaining) {
        for (int i = 0; i != dRemaining; ++i) {
            int n = dOff + i;
            data[n] = (byte)(data[n] ^ kdfOut[i]);
        }
    }

    private BigInteger nextK() {
        BigInteger k;
        int qBitLength = this.ecParams.getN().bitLength();
        while ((k = new BigInteger(qBitLength, this.random)).equals(ECConstants.ZERO) || k.compareTo(this.ecParams.getN()) >= 0) {
        }
        return k;
    }

    private void addFieldElement(ECFieldElement v) {
        byte[] p = BigIntegers.asUnsignedByteArray((int)this.curveLength, (BigInteger)v.toBigInteger());
        this.digest.update(p, 0, p.length);
    }

    public static enum SM2Mode {
        C1C2C3,
        C1C3C2;

    }
}

