/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.aoju.bus.gitlab.AbstractApi;
import org.aoju.bus.gitlab.Constants;
import org.aoju.bus.gitlab.GitLabApi;
import org.aoju.bus.gitlab.GitLabApiException;
import org.aoju.bus.gitlab.GitLabApiForm;
import org.aoju.bus.gitlab.Pager;
import org.aoju.bus.gitlab.models.ArtifactsFile;
import org.aoju.bus.gitlab.models.Job;

public class JobApi
extends AbstractApi
implements Constants {
    public JobApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Job> getJobs(Object projectIdOrPath) throws GitLabApiException {
        return this.getJobs(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Job> getJobs(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public Pager<Job> getJobs(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Job>(this, Job.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs");
    }

    public Stream<Job> getJobsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getJobs(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Job> getJobs(Object projectIdOrPath, Constants.JobScope scope) throws GitLabApiException {
        return this.getJobs(projectIdOrPath, scope, this.getDefaultPerPage()).all();
    }

    public Pager<Job> getJobs(Object projectIdOrPath, Constants.JobScope scope, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope);
        return new Pager<Job>(this, Job.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs");
    }

    public Stream<Job> getJobsStream(Object projectIdOrPath, Constants.JobScope scope) throws GitLabApiException {
        return this.getJobs(projectIdOrPath, scope, this.getDefaultPerPage()).stream();
    }

    public List<Job> getJobsForPipeline(Object projectIdOrPath, int pipelineId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public List<Job> getJobsForPipeline(Object projectIdOrPath, int pipelineId, Constants.JobScope scope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(){});
    }

    public Job getJob(Object projectIdOrPath, int jobId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId);
        return (Job)response.readEntity(Job.class);
    }

    public Optional<Job> getOptionalJob(Object projectIdOrPath, int jobId) {
        try {
            return Optional.ofNullable(this.getJob(projectIdOrPath, jobId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public File downloadArtifactsFile(Object projectIdOrPath, String ref, String jobName, File directory) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("job", jobName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", "artifacts", ref, "download");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = jobName + "-artifacts.zip";
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadArtifactsFile(Object projectIdOrPath, String ref, String jobName) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("job", jobName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", "artifacts", ref, "download");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File downloadArtifactsFile(Object projectIdOrPath, Integer jobId, File directory) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = "job-" + jobId + "-artifacts.zip";
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadArtifactsFile(Object projectIdOrPath, Integer jobId) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File downloadArtifactsFile(Object projectIdOrPath, Integer jobId, ArtifactsFile artifactsFile, File directory) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts", artifactsFile.getFilename());
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = artifactsFile.getFilename();
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadArtifactsFile(Object projectIdOrPath, Integer jobId, ArtifactsFile artifactsFile) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts", artifactsFile.getFilename());
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File downloadSingleArtifactsFile(Object projectIdOrPath, Integer jobId, Path artifactPath, File directory) throws GitLabApiException {
        String path = artifactPath.toString().replace("\\", "/");
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts", path);
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = artifactPath.getFileName().toString();
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadSingleArtifactsFile(Object projectIdOrPath, Integer jobId, Path artifactPath) throws GitLabApiException {
        String path = artifactPath.toString().replace("\\", "/");
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts", path);
        return (InputStream)response.readEntity(InputStream.class);
    }

    public String getTrace(Object projectIdOrPath, int jobId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "trace");
        return (String)response.readEntity(String.class);
    }

    public Job cancleJob(Object projectIdOrPath, int jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "cancel"});
        return (Job)response.readEntity(Job.class);
    }

    public Job retryJob(Object projectIdOrPath, int jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "retry"});
        return (Job)response.readEntity(Job.class);
    }

    public Job eraseJob(Object projectIdOrPath, int jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "erase"});
        return (Job)response.readEntity(Job.class);
    }

    public Job playJob(Object projectIdOrPath, int jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "play"});
        return (Job)response.readEntity(Job.class);
    }
}

