/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.freebsd;

import java.util.function.Supplier;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.hardware.AbstractFirmware;

final class FreeBsdFirmware
extends AbstractFirmware {
    private final Supplier<DmidecodeStrings> readDmiDecode = Memoizer.memoize(this::readDmiDecode);

    FreeBsdFirmware() {
    }

    @Override
    public String getManufacturer() {
        return this.readDmiDecode.get().manufacturer;
    }

    @Override
    public String getVersion() {
        return this.readDmiDecode.get().version;
    }

    @Override
    public String getReleaseDate() {
        return this.readDmiDecode.get().releaseDate;
    }

    private DmidecodeStrings readDmiDecode() {
        String manufacturer = null;
        String version = null;
        String releaseDate = "";
        String manufacturerMarker = "Vendor:";
        String versionMarker = "Version:";
        String releaseDateMarker = "Release Date:";
        for (String checkLine : Command.runNative("dmidecode -t bios")) {
            if (checkLine.contains("Vendor:")) {
                manufacturer = checkLine.split("Vendor:")[1].trim();
                continue;
            }
            if (checkLine.contains("Version:")) {
                version = checkLine.split("Version:")[1].trim();
                continue;
            }
            if (!checkLine.contains("Release Date:")) continue;
            releaseDate = checkLine.split("Release Date:")[1].trim();
        }
        releaseDate = Builder.parseMmDdYyyyToYyyyMmDD(releaseDate);
        return new DmidecodeStrings(manufacturer, version, releaseDate);
    }

    private static final class DmidecodeStrings {
        private final String manufacturer;
        private final String version;
        private final String releaseDate;

        private DmidecodeStrings(String manufacturer, String version, String releaseDate) {
            this.manufacturer = StringUtils.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.version = StringUtils.isBlank(version) ? "unknown" : version;
            this.releaseDate = StringUtils.isBlank(releaseDate) ? "unknown" : releaseDate;
        }
    }
}

