/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software.unix.freebsd;

import com.sun.jna.Native;
import com.sun.jna.ptr.PointerByReference;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.common.unix.CLibrary;
import org.aoju.bus.health.common.unix.freebsd.FreeBsdLibc;
import org.aoju.bus.health.software.AbstractNetwork;
import org.aoju.bus.logger.Logger;

public class FreeBsdNetwork
extends AbstractNetwork {
    private static final FreeBsdLibc LIBC = FreeBsdLibc.INSTANCE;

    @Override
    public String getDomainName() {
        PointerByReference ptr;
        CLibrary.Addrinfo hint = new CLibrary.Addrinfo();
        hint.ai_flags = 2;
        String hostname = this.getHostName();
        int res = LIBC.getaddrinfo(hostname, null, hint, ptr = new PointerByReference());
        if (res > 0) {
            Logger.warn("Failed getaddrinfo(): {}", LIBC.gai_strerror(res));
            return "";
        }
        CLibrary.Addrinfo info = new CLibrary.Addrinfo(ptr.getValue());
        String canonname = info.ai_canonname.trim();
        LIBC.freeaddrinfo(ptr.getValue());
        return canonname;
    }

    @Override
    public String getHostName() {
        byte[] hostnameBuffer = new byte[256];
        if (0 != LIBC.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString((byte[])hostnameBuffer);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return FreeBsdNetwork.searchGateway(Command.runNative("route -4 get default"));
    }

    @Override
    public String getIpv6DefaultGateway() {
        return FreeBsdNetwork.searchGateway(Command.runNative("route -6 get default"));
    }
}

