/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.provider;

import java.util.Set;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.builder.MapperBuilder;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.builder.SqlSourceBuilder;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.executor.SelectKey;
import org.apache.ibatis.mapping.MappedStatement;

public class BaseInsertProvider
extends MapperTemplate {
    public BaseInsertProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public String insert(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (!column.isInsertable() || Assert.isNotEmpty(column.getSequenceName())) continue;
            if (column.isIdentity()) {
                sql.append(SqlSourceBuilder.getBindCache(column));
                if (hasIdentityKey.booleanValue()) {
                    if (null != column.getGenerator() && "JDBC".equals(column.getGenerator())) continue;
                    throw new InstrumentException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                SelectKey.newSelectKeyMappedStatement(ms, column, entityClass, this.isBEFORE(), this.getIDENTITY(column));
                hasIdentityKey = true;
                continue;
            }
            if (!column.isUuid()) continue;
            sql.append(SqlSourceBuilder.getBindValue(column, this.getUUID()));
        }
        sql.append(SqlSourceBuilder.insertIntoTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlSourceBuilder.insertColumns(entityClass, false, false, false));
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(SqlSourceBuilder.getIfCacheNotNull(column, column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlSourceBuilder.getIfNotNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
            }
            if (Assert.isNotEmpty(column.getSequenceName())) {
                sql.append(SqlSourceBuilder.getIfIsNull(column, this.getSeqNextVal(column) + " ,", false));
                continue;
            }
            if (column.isIdentity()) {
                sql.append(SqlSourceBuilder.getIfCacheIsNull(column, column.getColumnHolder() + ","));
                continue;
            }
            if (column.isUuid()) {
                sql.append(SqlSourceBuilder.getIfIsNull(column, column.getColumnHolder(null, "_bind", ","), this.isNotEmpty()));
                continue;
            }
            sql.append(SqlSourceBuilder.getIfIsNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public String insertSelective(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (!column.isInsertable() || Assert.isNotEmpty(column.getSequenceName())) continue;
            if (column.isIdentity()) {
                sql.append(SqlSourceBuilder.getBindCache(column));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new InstrumentException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                SelectKey.newSelectKeyMappedStatement(ms, column, entityClass, this.isBEFORE(), this.getIDENTITY(column));
                hasIdentityKey = true;
                continue;
            }
            if (!column.isUuid()) continue;
            sql.append(SqlSourceBuilder.getBindValue(column, this.getUUID()));
        }
        sql.append(SqlSourceBuilder.insertIntoTable(entityClass, this.tableName(entityClass)));
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (Assert.isNotEmpty(column.getSequenceName()) || column.isIdentity() || column.isUuid()) {
                sql.append(column.getColumn() + ",");
                continue;
            }
            sql.append(SqlSourceBuilder.getIfNotNull(column, column.getColumn() + ",", this.isNotEmpty()));
        }
        sql.append("</trim>");
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(SqlSourceBuilder.getIfCacheNotNull(column, column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlSourceBuilder.getIfNotNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
            }
            if (Assert.isNotEmpty(column.getSequenceName())) {
                sql.append(SqlSourceBuilder.getIfIsNull(column, this.getSeqNextVal(column) + " ,", this.isNotEmpty()));
                continue;
            }
            if (column.isIdentity()) {
                sql.append(SqlSourceBuilder.getIfCacheIsNull(column, column.getColumnHolder() + ","));
                continue;
            }
            if (!column.isUuid()) continue;
            sql.append(SqlSourceBuilder.getIfIsNull(column, column.getColumnHolder(null, "_bind", ","), this.isNotEmpty()));
        }
        sql.append("</trim>");
        return sql.toString();
    }
}

