/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.process;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.office.process.AbstractProcessManager;

public class UnixProcessManager
extends AbstractProcessManager {
    private static final Pattern PS_OUTPUT_LINE = Pattern.compile("^\\s*(?<Pid>\\d+)\\s+(?<CommanLine>.*)$");
    private String[] runAsArgs;

    public static UnixProcessManager getDefault() {
        return DefaultHolder.INSTANCE;
    }

    @Override
    protected List<String> execute(String[] cmdarray) throws IOException {
        if (this.runAsArgs == null) {
            return super.execute(cmdarray);
        }
        String[] newarray = new String[this.runAsArgs.length + cmdarray.length];
        System.arraycopy(this.runAsArgs, 0, newarray, 0, this.runAsArgs.length);
        System.arraycopy(cmdarray, 0, newarray, this.runAsArgs.length, cmdarray.length);
        return super.execute(newarray);
    }

    @Override
    protected String[] getRunningProcessesCommand(String process) {
        return new String[]{"/bin/sh", "-c", "/bin/ps -e -o pid,args | /bin/grep " + process + " | /bin/grep -v grep"};
    }

    @Override
    protected Pattern getRunningProcessLinePattern() {
        return PS_OUTPUT_LINE;
    }

    @Override
    public void kill(Process process, long pid) throws IOException {
        this.execute(new String[]{"/bin/kill", "-KILL", String.valueOf(pid)});
    }

    public void setRunAsArgs(String[] runAsArgs) {
        this.runAsArgs = ArrayUtils.clone(runAsArgs);
    }

    private static class DefaultHolder {
        static final UnixProcessManager INSTANCE = new UnixProcessManager();

        private DefaultHolder() {
        }
    }
}

