/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.process;

import java.io.IOException;
import java.util.regex.Pattern;
import org.aoju.bus.office.process.AbstractProcessManager;

public class WindowsProcessManager
extends AbstractProcessManager {
    private static final Pattern PROCESS_GET_LINE = Pattern.compile("^\\s*(?<CommanLine>.*?)\\s+(?<Pid>\\d+)\\s*$");

    public static WindowsProcessManager getDefault() {
        return DefaultHolder.INSTANCE;
    }

    @Override
    protected String[] getRunningProcessesCommand(String process) {
        return new String[]{"cmd", "/c", "wmic process where(name like '" + process + "%') get commandline,processid"};
    }

    @Override
    protected Pattern getRunningProcessLinePattern() {
        return PROCESS_GET_LINE;
    }

    public boolean isUsable() {
        try {
            this.execute(new String[]{"wmic", "quit"});
            this.execute(new String[]{"taskkill", "/?"});
            return true;
        }
        catch (IOException ioEx) {
            return false;
        }
    }

    @Override
    public void kill(Process process, long pid) throws IOException {
        this.execute(new String[]{"taskkill", "/t", "/f", "/pid", String.valueOf(pid)});
    }

    private static class DefaultHolder {
        static final WindowsProcessManager INSTANCE = new WindowsProcessManager();

        private DefaultHolder() {
        }
    }
}

