/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.builder;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aoju.bus.core.builder.Different;
import org.aoju.bus.core.builder.ToStringBuilder;
import org.aoju.bus.core.builder.ToStringStyle;
import org.aoju.bus.core.lang.Assert;

public class DifferentResult
implements Iterable<Different<?>> {
    public static final String OBJECTS_SAME_STRING = "";
    private static final String DIFFERS_STRING = "differs from";
    private final List<Different<?>> differents;
    private final Object lhs;
    private final Object rhs;
    private final ToStringStyle style;

    DifferentResult(Object lhs, Object rhs, List<Different<?>> differents, ToStringStyle style) {
        Assert.isTrue(lhs != null, "Left hand object cannot be null", new Object[0]);
        Assert.isTrue(rhs != null, "Right hand object cannot be null", new Object[0]);
        Assert.isTrue(differents != null, "List of differences cannot be null", new Object[0]);
        this.differents = differents;
        this.lhs = lhs;
        this.rhs = rhs;
        this.style = style == null ? ToStringStyle.DEFAULT_STYLE : style;
    }

    public List<Different<?>> getDifferents() {
        return Collections.unmodifiableList(this.differents);
    }

    public int getNumberOfDiffs() {
        return this.differents.size();
    }

    public ToStringStyle getToStringStyle() {
        return this.style;
    }

    public String toString() {
        return this.toString(this.style);
    }

    public String toString(ToStringStyle style) {
        if (this.differents.isEmpty()) {
            return OBJECTS_SAME_STRING;
        }
        ToStringBuilder lhsBuilder = new ToStringBuilder(this.lhs, style);
        ToStringBuilder rhsBuilder = new ToStringBuilder(this.rhs, style);
        for (Different<?> different : this.differents) {
            lhsBuilder.append(different.getFieldName(), different.getLeft());
            rhsBuilder.append(different.getFieldName(), different.getRight());
        }
        return String.format("%s %s %s", lhsBuilder.build(), DIFFERS_STRING, rhsBuilder.build());
    }

    @Override
    public Iterator<Different<?>> iterator() {
        return this.differents.iterator();
    }
}

