/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.io.PageBuffer;

public class BufferPool {
    private static Timer timer = new Timer("BufferPoolClean", true);
    private PageBuffer[] pageBufferList;
    private volatile AtomicInteger cursor = new AtomicInteger(0);

    public BufferPool(int pageSize, int poolSize, boolean isDirect) {
        this.pageBufferList = new PageBuffer[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            this.pageBufferList[i] = new PageBuffer(pageSize, isDirect);
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (PageBuffer pageBuffer : BufferPool.this.pageBufferList) {
                    pageBuffer.tryClean();
                }
            }
        }, 500L, 1000L);
    }

    public PageBuffer allocateBufferPage() {
        return this.pageBufferList[this.cursor.getAndIncrement() % this.pageBufferList.length];
    }
}

