/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.execute;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.limiter.Injector;
import org.aoju.bus.limiter.expression.LimiterOperationExpressionEvaluator;
import org.aoju.bus.limiter.metadata.LimitedResourceMetadata;
import org.aoju.bus.limiter.resource.LimitedResource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;

public class LimiterExecutionContext {
    private static final HashMap<String, Object> emptyMap = new HashMap();
    private LimitedResourceMetadata metadata;
    private Object[] args;
    private Object target;
    private Map<String, Object> injectArgs;
    private LimiterOperationExpressionEvaluator evaluator;
    private BeanFactory beanFactory;
    private Object key;
    private Object fallbackResult;
    private Throwable throwable;

    public LimiterExecutionContext(LimitedResourceMetadata metadata, Object[] args, Object target, BeanFactory beanFactory) {
        this.metadata = metadata;
        this.args = this.extractArgs(metadata.getTargetMethod(), args);
        this.target = target;
        this.injectArgs = this.generateInjectArgs();
        this.beanFactory = beanFactory;
        this.evaluator = new LimiterOperationExpressionEvaluator();
        this.key = this.generateKey();
    }

    public static HashMap<String, Object> getEmptyMap() {
        return emptyMap;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean limit() {
        boolean ret;
        try {
            ret = this.metadata.getLimiter().limit(this.key, this.metadata.getLimiterParameters());
        }
        catch (Throwable throwable) {
            this.throwable = throwable;
            ret = this.metadata.getErrorHandler().resolve(throwable, this);
        }
        if (!ret) {
            this.fallbackResult = this.metadata.getFallback().resolve(this.metadata.getTargetMethod(), this.metadata.getTargetClass(), this.args, (LimitedResource)this.metadata.getLimitedResource(), this.target);
        }
        return ret;
    }

    public void release() {
        this.metadata.getLimiter().release(this.key, this.metadata.getLimiterParameters());
    }

    public Object getFallbackResult() {
        return this.fallbackResult;
    }

    private Object[] extractArgs(Method method, Object[] args) {
        if (!method.isVarArgs()) {
            return args;
        }
        Object[] varArgs = ObjectUtils.toObjectArray(args[args.length - 1]);
        Object[] combinedArgs = new Object[args.length - 1 + varArgs.length];
        System.arraycopy(args, 0, combinedArgs, 0, args.length - 1);
        System.arraycopy(varArgs, 0, combinedArgs, args.length - 1, varArgs.length);
        return combinedArgs;
    }

    private Object generateKey() {
        if (StringUtils.hasText(this.metadata.getLimitedResource().getKey())) {
            EvaluationContext evaluationContext = this.evaluator.createEvaluationContext(this.metadata.getLimiter(), this.metadata.getTargetMethod(), this.args, this.target, this.metadata.getTargetClass(), this.metadata.getTargetMethod(), this.injectArgs, this.beanFactory);
            Object evalKey = this.evaluator.key(this.metadata.getLimitedResource().getKey(), new AnnotatedElementKey((AnnotatedElement)this.metadata.getTargetMethod(), this.metadata.getTargetClass()), evaluationContext);
            Assert.notNull(evalKey, "key\u503c\u8ba1\u7b97\u4e3anull!", new Object[0]);
            return evalKey;
        }
        return this.metadata.getTargetClass().getName() + "#" + this.metadata.getTargetMethod().getName();
    }

    private Map<String, Object> generateInjectArgs() {
        if (CollUtils.isEmpty(this.metadata.getArgumentInjectors())) {
            return emptyMap;
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        Collection<Injector> argumentInjectors = this.metadata.getArgumentInjectors();
        for (Injector argumentInjector : argumentInjectors) {
            Map<String, Object> tempMap = argumentInjector.inject(this.args);
            if (tempMap.isEmpty()) continue;
            retVal.putAll(tempMap);
        }
        return retVal;
    }

    public LimitedResourceMetadata getMetadata() {
        return this.metadata;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object getTarget() {
        return this.target;
    }

    public Map<String, Object> getInjectArgs() {
        return this.injectArgs;
    }

    public LimiterOperationExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Object getKey() {
        return this.key;
    }
}

