/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger;

import org.aoju.bus.core.utils.CallerUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Log;
import org.aoju.bus.logger.LogFactory;
import org.aoju.bus.logger.level.Level;

public final class Logger {
    private static final String FQCN = Logger.class.getName();

    private Logger() {
    }

    public static void trace(String format, Object ... arguments) {
        Logger.trace(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void trace(Log log, String format, Object ... arguments) {
        log.trace(FQCN, null, format, arguments);
    }

    public static void debug(String format, Object ... arguments) {
        Logger.debug(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void debug(Log log, String format, Object ... arguments) {
        log.debug(FQCN, null, format, arguments);
    }

    public static void info(String format, Object ... arguments) {
        Logger.info(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void info(Log log, String format, Object ... arguments) {
        log.info(FQCN, null, format, arguments);
    }

    public static void warn(String format, Object ... arguments) {
        Logger.warn(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void warn(Throwable e, String format, Object ... arguments) {
        Logger.warn(LogFactory.get(CallerUtils.getCallers()), e, StringUtils.format(format, arguments), new Object[0]);
    }

    public static void warn(Log log, String format, Object ... arguments) {
        Logger.warn(log, null, format, arguments);
    }

    public static void warn(Log log, Throwable e, String format, Object ... arguments) {
        log.warn(FQCN, e, format, arguments);
    }

    public static void error(Throwable e) {
        Logger.error(LogFactory.get(CallerUtils.getCallers()), e);
    }

    public static void error(String format, Object ... arguments) {
        Logger.error(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void error(Throwable e, String format, Object ... arguments) {
        Logger.error(LogFactory.get(CallerUtils.getCallers()), e, format, arguments);
    }

    public static void error(Log log, Throwable e) {
        Logger.error(log, e, e.getMessage(), new Object[0]);
    }

    public static void error(Log log, String format, Object ... arguments) {
        Logger.error(log, null, format, arguments);
    }

    public static void error(Log log, Throwable e, String format, Object ... arguments) {
        log.error(FQCN, e, format, arguments);
    }

    public static void log(Level level, Throwable t, String format, Object ... arguments) {
        LogFactory.get(CallerUtils.getCallers()).log(FQCN, level, t, format, arguments);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.get(clazz);
    }

    public static Log get(String name) {
        return LogFactory.get(name);
    }

    public static Log get() {
        return LogFactory.get(CallerUtils.getCallers());
    }

    public boolean isTrace() {
        return LogFactory.get(CallerUtils.getCallers()).isTrace();
    }

    public boolean isDebug() {
        return LogFactory.get(CallerUtils.getCallers()).isDebug();
    }

    public boolean isInfo() {
        return LogFactory.get(CallerUtils.getCallers()).isInfo();
    }

    public boolean isWarn() {
        return LogFactory.get(CallerUtils.getCallers()).isWarn();
    }

    public boolean isError() {
        return LogFactory.get(CallerUtils.getCallers()).isError();
    }
}

