/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class DouyinProvider
extends DefaultProvider {
    public DouyinProvider(Context context) {
        super(context, Registry.DOUYIN);
    }

    public DouyinProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.DOUYIN, extendCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return this.getToken(this.accessTokenUrl(Callback2.getCode()));
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        JSONObject dataObj = object.getJSONObject("data");
        return Property.builder().uuid(dataObj.getString("union_id")).username(dataObj.getString("nickname")).nickname(dataObj.getString("nickname")).avatar(dataObj.getString("avatar")).remark(dataObj.getString("description")).gender(Normal.Gender.getGender(dataObj.getString("gender"))).location(String.format("%s %s %s", dataObj.getString("country"), dataObj.getString("province"), dataObj.getString("city"))).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken oldToken) {
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(oldToken.getRefreshToken()))).build();
    }

    private void checkResponse(JSONObject object) {
        String message = object.getString("message");
        JSONObject data = object.getJSONObject("data");
        int errorCode = data.getIntValue("error_code");
        if ("error".equals(message) || errorCode != 0) {
            throw new AuthorizedException("" + errorCode, data.getString("description"));
        }
    }

    private AccToken getToken(String accessTokenUrl) {
        JSONObject object = JSONObject.parseObject((String)Httpx.post(accessTokenUrl));
        this.checkResponse(object);
        JSONObject dataObj = object.getJSONObject("data");
        return AccToken.builder().accessToken(dataObj.getString("access_token")).openId(dataObj.getString("open_id")).expireIn(dataObj.getIntValue("expires_in")).refreshToken(dataObj.getString("refresh_token")).scope(dataObj.getString("scope")).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_key", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "user_info").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_key", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("open_id", token.getOpenId()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.source.refresh()).queryParam("client_key", this.context.getAppKey()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }
}

