/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class TwitterProvider
extends DefaultProvider {
    private static final String PREAMBLE = "OAuth";

    public TwitterProvider(Context context) {
        super(context, Registry.TWITTER);
    }

    public TwitterProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.TOUTIAO, extendCache);
    }

    private static String generateNonce(int len) {
        String s = "0123456789QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm";
        Random rng = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int index = rng.nextInt(62);
            sb.append(s, index, index + 1);
        }
        return sb.toString();
    }

    private static String sign(Map<String, String> params, String method, String baseUrl, String apiSecret, String tokenSecret) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, String> e : params.entrySet()) {
            map.put(TwitterProvider.urlEncode(e.getKey()), e.getValue());
        }
        String str = TwitterProvider.parseMapToString(map, true);
        String baseStr = method.toUpperCase() + "&" + TwitterProvider.urlEncode(baseUrl) + "&" + TwitterProvider.urlEncode(str);
        String signKey = apiSecret + "&" + (StringUtils.isEmpty(tokenSecret) ? "" : tokenSecret);
        byte[] signature = TwitterProvider.sign(signKey.getBytes(Charset.DEFAULT), baseStr.getBytes(Charset.DEFAULT), "HmacSHA1");
        return new String(Base64.encode(signature, false));
    }

    @Override
    protected String userInfoUrl(AccToken authToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("user_id", authToken.getUserId()).queryParam("screen_name", authToken.getScreenName()).queryParam("include_entities", true).build();
    }

    @Override
    protected AccToken getAccessToken(Callback authCallback) {
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_token", authCallback.getOauthToken());
        oauthParams.put("oauth_verifier", authCallback.getOauthVerifier());
        oauthParams.put("oauth_signature", TwitterProvider.sign(oauthParams, "POST", this.source.accessToken(), this.context.getAppSecret(), authCallback.getOauthToken()));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.buildHeader(oauthParams));
        header.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("oauth_verifier", authCallback.getOauthVerifier());
        String response = Httpx.post(this.source.accessToken(), queryMap, header);
        Map<String, String> requestToken = this.parseStringToMap(response, false);
        return AccToken.builder().oauthToken(requestToken.get("oauth_token")).oauthTokenSecret(requestToken.get("oauth_token_secret")).userId(requestToken.get("user_id")).screenName(requestToken.get("screen_name")).build();
    }

    @Override
    protected Property getUserInfo(AccToken authToken) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("user_id", authToken.getUserId());
        queryParams.put("screen_name", authToken.getScreenName());
        queryParams.put("include_entities", Boolean.toString(true));
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_token", authToken.getOauthToken());
        HashMap<String, String> params = new HashMap<String, String>(oauthParams);
        params.putAll(queryParams);
        oauthParams.put("oauth_signature", TwitterProvider.sign(params, "GET", this.source.userInfo(), this.context.getAppSecret(), authToken.getOauthTokenSecret()));
        String header = this.buildHeader(oauthParams);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Authorization", header);
        String response = Httpx.get(this.userInfoUrl(authToken), null, map);
        JSONObject userInfo = JSONObject.parseObject((String)response);
        return Property.builder().uuid(userInfo.getString("id_str")).username(userInfo.getString("screen_name")).nickname(userInfo.getString("name")).remark(userInfo.getString("description")).avatar(userInfo.getString("profile_image_url_https")).blog(userInfo.getString("url")).location(userInfo.getString("location")).source(this.source.toString()).token(authToken).build();
    }

    private Map<String, String> buildOauthParams() {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("oauth_consumer_key", this.context.getAppKey());
        params.put("oauth_nonce", TwitterProvider.generateNonce(32));
        params.put("oauth_signature_method", "HMAC-SHA1");
        params.put("oauth_timestamp", "" + DateUtils.timestamp());
        params.put("oauth_version", "1.0");
        return params;
    }

    private String buildHeader(Map<String, String> oauthParams) {
        StringBuilder sb = new StringBuilder(PREAMBLE);
        for (Map.Entry<String, String> param : oauthParams.entrySet()) {
            if (sb.length() > PREAMBLE.length()) {
                sb.append(", ");
            }
            sb.append(param.getKey()).append("=\"").append(TwitterProvider.urlEncode(param.getValue())).append('\"');
        }
        return sb.toString();
    }

    private AccToken getRequestToken() {
        String baseUrl = "https://api.twitter.com/oauth/request_token";
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_callback", this.context.getRedirectUri());
        oauthParams.put("oauth_signature", TwitterProvider.sign(oauthParams, "POST", baseUrl, this.context.getAppSecret(), null));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.buildHeader(oauthParams));
        String requestToken = Httpx.post(baseUrl, null, header);
        Map<String, String> res = this.parseStringToMap(requestToken, false);
        return AccToken.builder().oauthToken(res.get("oauth_token")).oauthTokenSecret(res.get("oauth_token_secret")).oauthCallbackConfirmed(Boolean.valueOf(res.get("oauth_callback_confirmed"))).build();
    }
}

