/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class WeChatMpProvider
extends DefaultProvider {
    public WeChatMpProvider(Context context) {
        super(context, Registry.WECHAT_MP);
    }

    public WeChatMpProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.WECHAT_MP, extendCache);
    }

    @Override
    protected AccToken getAccessToken(Callback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String openId = token.getOpenId();
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        String location = String.format("%s-%s-%s", object.getString("country"), object.getString("province"), object.getString("city"));
        if (object.containsKey((Object)"unionid")) {
            token.setUnionId(object.getString("unionid"));
        }
        return Property.builder().username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("headimgurl")).location(location).uuid(openId).gender(Normal.Gender.getGender(object.getString("sex"))).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken token) {
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(token.getRefreshToken()))).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"errcode")) {
            throw new AuthorizedException(StringUtils.toString(object.getIntValue("errcode")), object.getString("errmsg"));
        }
    }

    private AccToken getToken(String accessTokenUrl) {
        JSONObject object = JSONObject.parseObject((String)Httpx.get(accessTokenUrl));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).openId(object.getString("openid")).scope(object.getString("scope")).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("appid", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("response_type", "code").queryParam("scope", "snsapi_userinfo").queryParam("state", this.getRealState(state).concat("#wechat_redirect")).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("appid", this.context.getAppKey()).queryParam("secret", this.context.getAppSecret()).queryParam("code", code).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("openid", accToken.getOpenId()).queryParam("lang", "zh_CN").build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.source.refresh()).queryParam("appid", this.context.getAppKey()).queryParam("grant_type", "refresh_token").queryParam("refresh_token", refreshToken).build();
    }
}

