/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import java.io.File;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Protocol;
import org.aoju.bus.office.bridge.LocalOfficeBridgeFactory;
import org.aoju.bus.office.builtin.MadeInOffice;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.metric.AbstractOfficeManager;
import org.aoju.bus.office.metric.ConnectRetryable;
import org.aoju.bus.office.metric.ExternalOfficeBuilder;
import org.aoju.bus.office.metric.InstalledOfficeHolder;

public final class ExternalOfficeManager
extends AbstractOfficeManager {
    private final LocalOfficeBridgeFactory localOffice;

    private ExternalOfficeManager(UnoUrl unoUrl, ExternalOfficeBuilder config) {
        super(config);
        this.localOffice = new LocalOfficeBridgeFactory(unoUrl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ExternalOfficeManager make() {
        return ExternalOfficeManager.builder().build();
    }

    public static ExternalOfficeManager install() {
        return ((Builder)ExternalOfficeManager.builder().install()).build();
    }

    private void connect() throws InstrumentException {
        try {
            ExternalOfficeBuilder mconfig = (ExternalOfficeBuilder)this.config;
            new ConnectRetryable(this.localOffice).execute(mconfig.getRetryInterval(), mconfig.getConnectTimeout());
        }
        catch (Exception ex) {
            throw new InstrumentException("Could not establish connection to external office process", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MadeInOffice task) throws InstrumentException {
        LocalOfficeBridgeFactory localOfficeBridgeFactory = this.localOffice;
        synchronized (localOfficeBridgeFactory) {
            if (!this.isRunning()) {
                this.connect();
            }
            task.execute(this.localOffice);
        }
    }

    @Override
    public boolean isRunning() {
        return this.localOffice.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws InstrumentException {
        if (((ExternalOfficeBuilder)this.config).isConnectOnStart()) {
            LocalOfficeBridgeFactory localOfficeBridgeFactory = this.localOffice;
            synchronized (localOfficeBridgeFactory) {
                this.connect();
                this.makeTempDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LocalOfficeBridgeFactory localOfficeBridgeFactory = this.localOffice;
        synchronized (localOfficeBridgeFactory) {
            if (this.isRunning()) {
                try {
                    this.localOffice.disconnect();
                }
                finally {
                    this.deleteTempDir();
                }
            }
        }
    }

    public static final class Builder
    extends AbstractOfficeManager.AbstractOfficeManagerBuilder<Builder> {
        private Protocol connectionProtocol = Protocol.SOCKET;
        private int portNumber = 8102;
        private String pipeName = "office";
        private boolean connectOnStart = true;
        private long connectTimeout = 120000L;
        private long retryInterval = 250L;

        private Builder() {
        }

        @Override
        public ExternalOfficeManager build() {
            if (this.workingDir == null) {
                this.workingDir = new File(System.getProperty("java.io.tmpdir"));
            }
            org.aoju.bus.office.Builder.validateOfficeWorkingDirectory(this.workingDir);
            ExternalOfficeManager manager = new ExternalOfficeManager(this.connectionProtocol == Protocol.SOCKET ? new UnoUrl(this.portNumber) : (this.pipeName != null ? new UnoUrl(this.pipeName) : new UnoUrl(8102)), new ExternalOfficeBuilder(this.workingDir, this.connectOnStart, this.connectTimeout, this.retryInterval));
            if (this.install) {
                InstalledOfficeHolder.setInstance(manager);
            }
            return manager;
        }

        public Builder connectionProtocol(Protocol connectionProtocol) {
            this.connectionProtocol = connectionProtocol;
            return this;
        }

        public Builder pipeName(String pipeName) {
            this.pipeName = pipeName;
            return this;
        }

        public Builder portNumber(int portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder connectOnStart(boolean connectOnStart) {
            this.connectOnStart = connectOnStart;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder retryInterval(long retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }
    }
}

