/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.ObjectUtils;

public class TemporalConverter
extends AbstractConverter<TemporalAccessor> {
    private final Class<?> targetType;
    private String format;

    public TemporalConverter(Class<?> targetType) {
        this.targetType = targetType;
    }

    public TemporalConverter(Class<?> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected TemporalAccessor convertInternal(Object value) {
        if (value instanceof Long) {
            return this.parseFromLong((Long)value);
        }
        if (value instanceof TemporalAccessor) {
            return this.parseFromTemporalAccessor((TemporalAccessor)value);
        }
        if (value instanceof Date) {
            DateTime dateTime = DateUtils.date((Date)value);
            return this.parseFromInstant(dateTime.toInstant(), dateTime.getZoneId());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return this.parseFromInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        return this.parseFromCharSequence(this.convertToStr(value));
    }

    private TemporalAccessor parseFromCharSequence(CharSequence value) {
        ZoneId zoneId;
        Instant instant;
        if (null != this.format) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.format);
            instant = formatter.parse(value, Instant::from);
            zoneId = formatter.getZone();
        } else {
            DateTime dateTime = DateUtils.parse(value);
            instant = Objects.requireNonNull(dateTime).toInstant();
            zoneId = dateTime.getZoneId();
        }
        return this.parseFromInstant(instant, zoneId);
    }

    private TemporalAccessor parseFromLong(Long time) {
        return this.parseFromInstant(Instant.ofEpochMilli(time), null);
    }

    private TemporalAccessor parseFromTemporalAccessor(TemporalAccessor temporalAccessor) {
        TemporalAccessor result = null;
        if (temporalAccessor instanceof LocalDateTime) {
            result = this.parseFromLocalDateTime((LocalDateTime)temporalAccessor);
        } else if (temporalAccessor instanceof ZonedDateTime) {
            result = this.parseFromZonedDateTime((ZonedDateTime)temporalAccessor);
        }
        if (null == result) {
            result = this.parseFromInstant(DateUtils.toInstant(temporalAccessor), null);
        }
        return result;
    }

    private TemporalAccessor parseFromLocalDateTime(LocalDateTime localDateTime) {
        if (Instant.class.equals(this.targetType)) {
            return DateUtils.toInstant(localDateTime);
        }
        if (LocalDate.class.equals(this.targetType)) {
            return localDateTime.toLocalDate();
        }
        if (LocalTime.class.equals(this.targetType)) {
            return localDateTime.toLocalTime();
        }
        if (ZonedDateTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault());
        }
        if (OffsetDateTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (OffsetTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromZonedDateTime(ZonedDateTime zonedDateTime) {
        if (Instant.class.equals(this.targetType)) {
            return DateUtils.toInstant(zonedDateTime);
        }
        if (LocalDateTime.class.equals(this.targetType)) {
            return zonedDateTime.toLocalDateTime();
        }
        if (LocalDate.class.equals(this.targetType)) {
            return zonedDateTime.toLocalDate();
        }
        if (LocalTime.class.equals(this.targetType)) {
            return zonedDateTime.toLocalTime();
        }
        if (OffsetDateTime.class.equals(this.targetType)) {
            return zonedDateTime.toOffsetDateTime();
        }
        if (OffsetTime.class.equals(this.targetType)) {
            return zonedDateTime.toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromInstant(Instant instant, ZoneId zoneId) {
        if (Instant.class.equals(this.targetType)) {
            return instant;
        }
        zoneId = ObjectUtils.defaultIfNull(zoneId, ZoneId.systemDefault());
        Comparable<ChronoLocalDateTime<?>> result = null;
        if (LocalDateTime.class.equals(this.targetType)) {
            result = LocalDateTime.ofInstant(instant, zoneId);
        } else if (LocalDate.class.equals(this.targetType)) {
            result = instant.atZone(zoneId).toLocalDate();
        } else if (LocalTime.class.equals(this.targetType)) {
            result = instant.atZone(zoneId).toLocalTime();
        } else if (ZonedDateTime.class.equals(this.targetType)) {
            result = instant.atZone(zoneId);
        } else if (OffsetDateTime.class.equals(this.targetType)) {
            result = OffsetDateTime.ofInstant(instant, zoneId);
        } else if (OffsetTime.class.equals(this.targetType)) {
            result = OffsetTime.ofInstant(instant, zoneId);
        }
        return result;
    }
}

