/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.StringUtils;

public class Typed
implements ParameterizedType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Type rawType;

    public Typed(Type[] actualTypeArguments, Type ownerType, Type rawType) {
        this.actualTypeArguments = actualTypeArguments;
        this.ownerType = ownerType;
        this.rawType = rawType;
    }

    private static StringBuilder appendAllTo(StringBuilder buf, String sep, Type ... types) {
        if (ArrayUtils.isNotEmpty(types)) {
            boolean isFirst = true;
            for (Type type : types) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(sep);
                }
                String typeStr = type instanceof Class ? ((Class)type).getName() : StringUtils.toString(type);
                buf.append(typeStr);
            }
        }
        return buf;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Type useOwner = this.ownerType;
        Class raw = (Class)this.rawType;
        if (useOwner == null) {
            buf.append(raw.getName());
        } else {
            if (useOwner instanceof Class) {
                buf.append(((Class)useOwner).getName());
            } else {
                buf.append(useOwner.toString());
            }
            buf.append('.').append(raw.getSimpleName());
        }
        Typed.appendAllTo(buf.append('<'), ", ", this.actualTypeArguments).append('>');
        return buf.toString();
    }
}

