/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab.models;

import java.util.Arrays;
import java.util.List;
import org.aoju.bus.gitlab.Constants;
import org.aoju.bus.gitlab.GitLabApiForm;

public class MergeRequestParams {
    private String sourceBranch;
    private String targetBranch;
    private String title;
    private Integer assigneeId;
    private List<Integer> assigneeIds;
    private Integer milestoneId;
    private List<String> labels;
    private String description;
    private Integer targetProjectId;
    private Constants.StateEvent stateEvent;
    private Boolean removeSourceBranch;
    private Boolean squash;
    private Boolean discussionLocked;
    private Boolean allowCollaboration;
    private Integer approvalsBeforeMerge;

    public MergeRequestParams withSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
        return this;
    }

    public MergeRequestParams withTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
        return this;
    }

    public MergeRequestParams withTitle(String title) {
        this.title = title;
        return this;
    }

    public MergeRequestParams withAssigneeId(Integer assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    public MergeRequestParams withAssigneeIds(List<Integer> assigneeIds) {
        this.assigneeIds = assigneeIds;
        return this;
    }

    public MergeRequestParams withMilestoneId(Integer milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    public MergeRequestParams withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public MergeRequestParams withLabels(String[] labels) {
        this.labels = labels != null ? Arrays.asList(labels) : null;
        return this;
    }

    public MergeRequestParams withDescription(String description) {
        this.description = description;
        return this;
    }

    public MergeRequestParams withTargetProjectId(Integer targetProjectId) {
        this.targetProjectId = targetProjectId;
        return this;
    }

    public MergeRequestParams withStateEvent(Constants.StateEvent stateEvent) {
        this.stateEvent = stateEvent;
        return this;
    }

    public MergeRequestParams withRemoveSourceBranch(Boolean removeSourceBranch) {
        this.removeSourceBranch = removeSourceBranch;
        return this;
    }

    public MergeRequestParams withSquash(Boolean squash) {
        this.squash = squash;
        return this;
    }

    public MergeRequestParams withDiscussionLocked(Boolean discussionLocked) {
        this.discussionLocked = discussionLocked;
        return this;
    }

    public MergeRequestParams withAllowCollaboration(Boolean allowCollaboration) {
        this.allowCollaboration = allowCollaboration;
        return this;
    }

    public MergeRequestParams withApprovalsBeforeMerge(Integer approvalsBeforeMerge) {
        this.approvalsBeforeMerge = approvalsBeforeMerge;
        return this;
    }

    public GitLabApiForm getForm(boolean isCreate) {
        GitLabApiForm form = new GitLabApiForm().withParam("target_branch", this.targetBranch, isCreate).withParam("title", this.title, isCreate).withParam("assignee_id", this.assigneeId).withParam("assignee_ids", this.assigneeIds).withParam("milestone_id", this.milestoneId).withParam("labels", this.labels != null ? String.join((CharSequence)",", this.labels) : null).withParam("description", this.description).withParam("remove_source_branch", this.removeSourceBranch).withParam("squash", this.squash).withParam("allow_collaboration", this.allowCollaboration);
        if (isCreate) {
            form.withParam("source_branch", this.sourceBranch, true).withParam("target_project_id", this.targetProjectId).withParam("approvals_before_merge", this.approvalsBeforeMerge);
        } else {
            form.withParam("state_event", (Object)this.stateEvent).withParam("discussion_locked", this.discussionLocked);
        }
        return form;
    }
}

