/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.linux;

import com.sun.jna.platform.linux.LibC;
import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.linux.ProcUtils;
import org.aoju.bus.health.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.hardware.VirtualMemory;
import org.aoju.bus.health.hardware.linux.LinuxVirtualMemory;
import org.aoju.bus.logger.Logger;

public class LinuxGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<MemInfo> memInfo = Memoizer.memoize(this::readMemInfo, Memoizer.defaultExpiration());
    private final Supplier<Long> pageSize = Memoizer.memoize(this::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    @Override
    public long getAvailable() {
        return this.memInfo.get().available;
    }

    @Override
    public long getTotal() {
        return this.memInfo.get().total;
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private long queryPageSize() {
        try {
            LibC.Sysinfo info = new LibC.Sysinfo();
            if (0 == LibC.INSTANCE.sysinfo(info)) {
                return info.mem_unit;
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            Logger.debug("Failed to get sysinfo. {}", e);
        }
        return Builder.parseLongOrDefault(Command.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
    }

    private MemInfo readMemInfo() {
        long memFree = 0L;
        long activeFile = 0L;
        long inactiveFile = 0L;
        long sReclaimable = 0L;
        long memTotal = 0L;
        List<String> procMemInfo = Builder.readFile(ProcUtils.getProcPath() + "/meminfo");
        for (String checkLine : procMemInfo) {
            String[] memorySplit = Builder.whitespaces.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "MemTotal:": {
                    memTotal = this.parseMeminfo(memorySplit);
                    break;
                }
                case "MemAvailable:": {
                    long memAvailable = this.parseMeminfo(memorySplit);
                    return new MemInfo(memTotal, memAvailable);
                }
                case "MemFree:": {
                    memFree = this.parseMeminfo(memorySplit);
                    break;
                }
                case "Active(file):": {
                    activeFile = this.parseMeminfo(memorySplit);
                    break;
                }
                case "Inactive(file):": {
                    inactiveFile = this.parseMeminfo(memorySplit);
                    break;
                }
                case "SReclaimable:": {
                    sReclaimable = this.parseMeminfo(memorySplit);
                    break;
                }
            }
        }
        return new MemInfo(memTotal, memFree + activeFile + inactiveFile + sReclaimable);
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = Builder.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }

    private VirtualMemory createVirtualMemory() {
        return new LinuxVirtualMemory();
    }

    private static final class MemInfo {
        private final long total;
        private final long available;

        private MemInfo(long total, long available) {
            this.total = total;
            this.available = available;
        }
    }
}

