/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.mac;

import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.hardware.AbstractComputerSystem;
import org.aoju.bus.health.hardware.Baseboard;
import org.aoju.bus.health.hardware.Firmware;
import org.aoju.bus.health.hardware.mac.MacBaseboard;
import org.aoju.bus.health.hardware.mac.MacFirmware;

final class MacComputerSystem
extends AbstractComputerSystem {
    private final Supplier<ManufacturerModelSerial> profileSystem = Memoizer.memoize(this::platformExpert);

    MacComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.profileSystem.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.profileSystem.get().model;
    }

    @Override
    public String getSerialNumber() {
        return this.profileSystem.get().serialNumber;
    }

    @Override
    public Firmware createFirmware() {
        return new MacFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new MacBaseboard();
    }

    private ManufacturerModelSerial platformExpert() {
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                manufacturer = new String(data, StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("model")) != null) {
                model = new String(data, StandardCharsets.UTF_8);
            }
            serialNumber = platformExpert.getStringProperty("IOPlatformSerialNumber");
            platformExpert.release();
        }
        return new ManufacturerModelSerial(manufacturer, model, serialNumber);
    }

    private static final class ManufacturerModelSerial {
        private final String manufacturer;
        private final String model;
        private final String serialNumber;

        private ManufacturerModelSerial(String manufacturer, String model, String serialNumber) {
            this.manufacturer = StringUtils.isBlank(manufacturer) ? "Apple Inc." : manufacturer;
            this.model = StringUtils.isBlank(model) ? "unknown" : model;
            this.serialNumber = StringUtils.isBlank(serialNumber) ? "unknown" : serialNumber;
        }
    }
}

