/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.io.IOException;
import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aoju.bus.http.Builder;
import org.aoju.bus.http.Cookie;
import org.aoju.bus.http.UnoUrl;
import org.aoju.bus.http.metric.CookieJar;
import org.aoju.bus.logger.Logger;

public final class NetCookieJar
implements CookieJar {
    private final CookieHandler cookieHandler;

    public NetCookieJar(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    @Override
    public void saveFromResponse(UnoUrl url, List<Cookie> cookies) {
        if (this.cookieHandler != null) {
            ArrayList<String> cookieStrings = new ArrayList<String>();
            for (Cookie cookie : cookies) {
                cookieStrings.add(cookie.toString(true));
            }
            Map<String, List<String>> multimap = Collections.singletonMap("Set-Cookie", cookieStrings);
            try {
                this.cookieHandler.put(url.uri(), multimap);
            }
            catch (IOException e) {
                Logger.warn("Saving cookies failed for " + url.resolve("/..."), e);
            }
        }
    }

    @Override
    public List<Cookie> loadForRequest(UnoUrl url) {
        Map<String, List<String>> cookieHeaders;
        Map<String, List<String>> headers = Collections.emptyMap();
        try {
            cookieHeaders = this.cookieHandler.get(url.uri(), headers);
        }
        catch (IOException e) {
            Logger.warn("Loading cookies failed for " + url.resolve("/..."), e);
            return Collections.emptyList();
        }
        ArrayList<Cookie> cookies = null;
        for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
            String key = entry.getKey();
            if (!"Cookie".equalsIgnoreCase(key) && !"Cookie2".equalsIgnoreCase(key) || entry.getValue().isEmpty()) continue;
            for (String header : entry.getValue()) {
                if (cookies == null) {
                    cookies = new ArrayList<Cookie>();
                }
                cookies.addAll(this.decodeHeaderAsJavaNetCookies(url, header));
            }
        }
        return cookies != null ? Collections.unmodifiableList(cookies) : Collections.emptyList();
    }

    private List<Cookie> decodeHeaderAsJavaNetCookies(UnoUrl url, String header) {
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        int pos = 0;
        int limit = header.length();
        while (pos < limit) {
            int pairEnd = Builder.delimiterOffset(header, pos, limit, ";,");
            int equalsSign = Builder.delimiterOffset(header, pos, pairEnd, '=');
            String name = Builder.trimSubstring(header, pos, equalsSign);
            if (!name.startsWith("$")) {
                String value;
                String string = value = equalsSign < pairEnd ? Builder.trimSubstring(header, equalsSign + 1, pairEnd) : "";
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                result.add(new Cookie.Builder().name(name).value(value).domain(url.host()).build());
            }
            pos = pairEnd + 1;
        }
        return result;
    }
}

