/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.UriUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Complex;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Provider;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthCache;

public abstract class DefaultProvider
implements Provider {
    protected Context context;
    protected Complex source;
    protected ExtendCache extendCache;

    public DefaultProvider(Context context, Complex source) {
        this(context, source, OauthCache.INSTANCE);
    }

    public DefaultProvider(Context context, Complex source, ExtendCache extendCache) {
        this.context = context;
        this.source = source;
        this.extendCache = extendCache;
        if (!DefaultProvider.isSupportedAuth(context, source)) {
            throw new AuthorizedException(Builder.ErrorCode.PARAMETER_INCOMPLETE.getCode());
        }
        DefaultProvider.checkContext(context, source);
    }

    public static boolean isSupportedAuth(Context context, Complex source) {
        boolean isSupported;
        boolean bl = isSupported = StringUtils.isNotEmpty(context.getAppKey()) && StringUtils.isNotEmpty(context.getAppSecret()) && StringUtils.isNotEmpty(context.getRedirectUri());
        if (isSupported && Registry.ALIPAY == source) {
            isSupported = StringUtils.isNotEmpty(context.getPublicKey());
        }
        if (isSupported && Registry.STACKOVERFLOW == source) {
            isSupported = StringUtils.isNotEmpty(context.getOverflowKey());
        }
        if (isSupported && Registry.WECHAT_EE == source) {
            isSupported = StringUtils.isNotEmpty(context.getAgentId());
        }
        return isSupported;
    }

    public static boolean isHttpProtocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("http://");
    }

    public static boolean isHttpsProtocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("https://");
    }

    public static boolean isLocalHost(String url) {
        return StringUtils.isEmpty(url) || url.contains("127.0.0.1") || url.contains("localhost");
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, Charset.UTF_8.displayName());
            return encoded.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthorizedException("Failed To Encode Uri", e);
        }
    }

    public static String urlDecode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLDecoder.decode(value, Charset.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthorizedException("Failed To Decode Uri", e);
        }
    }

    public static byte[] sign(byte[] key, byte[] data, String algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthorizedException("Unsupported algorithm: " + algorithm, ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthorizedException("Invalid key: " + Arrays.toString(key), ex);
        }
    }

    public static void checkContext(Context context, Complex source) {
        String redirectUri = context.getRedirectUri();
        if (!DefaultProvider.isHttpProtocol(redirectUri) && !DefaultProvider.isHttpsProtocol(redirectUri)) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_REDIRECT_URI.getCode());
        }
        if (Registry.FACEBOOK == source && !DefaultProvider.isHttpsProtocol(redirectUri)) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_REDIRECT_URI.getCode());
        }
        if (Registry.ALIPAY == source && DefaultProvider.isLocalHost(redirectUri)) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_REDIRECT_URI.getCode());
        }
    }

    public static void checkCode(Complex complex, Callback callback) {
        String code = callback.getCode();
        if (complex == Registry.ALIPAY) {
            code = callback.getAuth_code();
        } else if (complex == Registry.HUAWEI) {
            code = callback.getAuthorization_code();
        }
        if (StringUtils.isEmpty(code)) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_CODE.getCode());
        }
    }

    public static String appendIfNotContain(String str, String appendStr, String otherwise) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(appendStr)) {
            return str;
        }
        if (str.contains(appendStr)) {
            return str.concat(otherwise);
        }
        return str.concat(appendStr);
    }

    public static Map<String, String> parseStringToMap(String accessTokenStr) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (accessTokenStr.contains("&")) {
            String[] fields;
            for (String field : fields = accessTokenStr.split("&")) {
                if (!field.contains("=")) continue;
                String[] keyValue = field.split("=");
                res.put(DefaultProvider.urlDecode(keyValue[0]), keyValue.length == 2 ? DefaultProvider.urlDecode(keyValue[1]) : null);
            }
        }
        return res;
    }

    public static String parseMapToString(Map<String, Object> params, boolean encode) {
        ArrayList paramList = new ArrayList();
        params.forEach((k, v) -> {
            if (ObjectUtils.isNull(v)) {
                paramList.add(k + "=");
            } else {
                String valueString = v.toString();
                paramList.add(k + "=" + (encode ? DefaultProvider.urlEncode(valueString) : valueString));
            }
        });
        return CollUtils.join(paramList, (CharSequence)"&");
    }

    public static Map<String, Object> parseQueryToMap(String url) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UriUtils.decodeVal(url, "UTF-8").forEach(paramMap::put);
        return paramMap;
    }

    @Override
    public Message login(Callback Callback2) {
        try {
            DefaultProvider.checkCode(this.source, Callback2);
            this.checkState(Callback2.getState());
            AccToken token = this.getAccessToken(Callback2);
            Property user = (Property)this.getUserInfo(token);
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(user).build();
        }
        catch (Exception e) {
            String errorCode = "" + Builder.ErrorCode.FAILURE.getCode();
            if (e instanceof AuthorizedException) {
                errorCode = ((AuthorizedException)e).getErrcode();
            }
            return Message.builder().errcode(errorCode).errmsg(e.getMessage()).build();
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    protected abstract AccToken getAccessToken(Callback var1);

    protected abstract Object getUserInfo(AccToken var1);

    protected Normal.Gender getRealGender(JSONObject object) {
        int genderCodeInt = object.getIntValue("gender");
        String genderCode = genderCodeInt == 1 ? "0" : (genderCodeInt == 0 ? "1" : genderCodeInt + "");
        return Normal.Gender.getGender(genderCode);
    }

    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.source.refresh()).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    protected String userInfoUrl(AccToken token) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).build();
    }

    protected String revokeUrl(AccToken token) {
        return Builder.fromUrl(this.source.revoke()).queryParam("access_token", token.getAccessToken()).build();
    }

    protected String getRealState(String state) {
        if (StringUtils.isEmpty(state)) {
            state = ObjectID.id();
        }
        this.extendCache.cache(state, state);
        return state;
    }

    protected String doPostAuthorizationCode(String code) {
        return Httpx.post(this.accessTokenUrl(code));
    }

    protected String doGetAuthorizationCode(String code) {
        return Httpx.get(this.accessTokenUrl(code));
    }

    protected String doGetUserInfo(AccToken token) {
        return Httpx.get(this.userInfoUrl(token));
    }

    protected String doGetRevoke(AccToken token) {
        return Httpx.get(this.revokeUrl(token));
    }

    protected void checkState(String state) {
        if (StringUtils.isEmpty(state) || ObjectUtils.isEmpty(this.extendCache.get(state))) {
            throw new AuthorizedException("" + (Object)((Object)Builder.ErrorCode.ILLEGAL_REQUEST));
        }
    }

    public Map<String, String> parseStringToMap(String str, boolean decode) {
        int i;
        if (StringUtils.isNotEmpty(str)) {
            int endPos;
            int beginPos = str.indexOf("?");
            if (beginPos > -1) {
                str = str.substring(beginPos + 1);
            }
            if ((endPos = str.indexOf("#")) > -1) {
                str = str.substring(0, endPos);
            }
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        if (StringUtils.isEmpty(str)) {
            return params;
        }
        if (!str.contains("&")) {
            params.put(decode ? DefaultProvider.urlDecode(str) : str, "");
            return params;
        }
        int len = str.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '=') {
                if (null == name) {
                    name = str.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name && pos != i) {
                this.addParam(params, str.substring(pos, i), "", decode);
            } else if (name != null) {
                this.addParam(params, name, str.substring(pos, i), decode);
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                this.addParam(params, str.substring(pos, i), "", decode);
            } else {
                this.addParam(params, name, str.substring(pos, i), decode);
            }
        } else if (name != null) {
            this.addParam(params, name, "", decode);
        }
        return params;
    }

    private void addParam(Map<String, String> params, String key, String value, boolean decode) {
        key = decode ? DefaultProvider.urlDecode(key) : key;
        String string = value = decode ? DefaultProvider.urlDecode(value) : value;
        if (params.containsKey(key)) {
            params.put(key, params.get(key) + "," + value);
        } else {
            params.put(key, value);
        }
    }
}

